// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the provisioning profiles within the Amazon Web Services account.
func (c *Client) ListProvisioningProfiles(ctx context.Context, params *ListProvisioningProfilesInput, optFns ...func(*Options)) (*ListProvisioningProfilesOutput, error) {
	if params == nil {
		params = &ListProvisioningProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProvisioningProfiles", params, optFns, c.addOperationListProvisioningProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListProvisioningProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListProvisioningProfilesInput struct {

	// The maximum number of results to return at one time.
	MaxResults *int32

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListProvisioningProfilesOutput struct {

	// The list of provisioning profiles.
	Items []types.ProvisioningProfileSummary

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListProvisioningProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListProvisioningProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListProvisioningProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListProvisioningProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProvisioningProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListProvisioningProfilesPaginatorOptions is the paginator options for
// ListProvisioningProfiles
type ListProvisioningProfilesPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListProvisioningProfilesPaginator is a paginator for ListProvisioningProfiles
type ListProvisioningProfilesPaginator struct {
	options   ListProvisioningProfilesPaginatorOptions
	client    ListProvisioningProfilesAPIClient
	params    *ListProvisioningProfilesInput
	nextToken *string
	firstPage bool
}

// NewListProvisioningProfilesPaginator returns a new
// ListProvisioningProfilesPaginator
func NewListProvisioningProfilesPaginator(client ListProvisioningProfilesAPIClient, params *ListProvisioningProfilesInput, optFns ...func(*ListProvisioningProfilesPaginatorOptions)) *ListProvisioningProfilesPaginator {
	if params == nil {
		params = &ListProvisioningProfilesInput{}
	}

	options := ListProvisioningProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListProvisioningProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListProvisioningProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListProvisioningProfiles page.
func (p *ListProvisioningProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListProvisioningProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListProvisioningProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListProvisioningProfilesAPIClient is a client that implements the
// ListProvisioningProfiles operation.
type ListProvisioningProfilesAPIClient interface {
	ListProvisioningProfiles(context.Context, *ListProvisioningProfilesInput, ...func(*Options)) (*ListProvisioningProfilesOutput, error)
}

var _ ListProvisioningProfilesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListProvisioningProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListProvisioningProfiles",
	}
}
