// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotfleetwise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Updates a decoder manifest.
//
// A decoder manifest can only be updated when the status is DRAFT . Only ACTIVE
// decoder manifests can be associated with vehicles.
func (c *Client) UpdateDecoderManifest(ctx context.Context, params *UpdateDecoderManifestInput, optFns ...func(*Options)) (*UpdateDecoderManifestOutput, error) {
	if params == nil {
		params = &UpdateDecoderManifestInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDecoderManifest", params, optFns, c.addOperationUpdateDecoderManifestMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDecoderManifestOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDecoderManifestInput struct {

	//  The name of the decoder manifest to update.
	//
	// This member is required.
	Name *string

	// Use default decoders for all unmapped signals in the model. You don't need to
	// provide any detailed decoding information.
	//
	// Access to certain Amazon Web Services IoT FleetWise features is currently
	// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
	// Developer Guide.
	//
	// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
	DefaultForUnmappedSignals types.DefaultForUnmappedSignalsType

	//  A brief description of the decoder manifest to update.
	Description *string

	//  A list of information about the network interfaces to add to the decoder
	// manifest.
	NetworkInterfacesToAdd []types.NetworkInterface

	//  A list of network interfaces to remove from the decoder manifest.
	NetworkInterfacesToRemove []string

	//  A list of information about the network interfaces to update in the decoder
	// manifest.
	NetworkInterfacesToUpdate []types.NetworkInterface

	//  A list of information about decoding additional signals to add to the decoder
	// manifest.
	SignalDecodersToAdd []types.SignalDecoder

	//  A list of signal decoders to remove from the decoder manifest.
	SignalDecodersToRemove []string

	//  A list of updated information about decoding signals to update in the decoder
	// manifest.
	SignalDecodersToUpdate []types.SignalDecoder

	//  The state of the decoder manifest. If the status is ACTIVE , the decoder
	// manifest can't be edited. If the status is DRAFT , you can edit the decoder
	// manifest.
	Status types.ManifestStatus

	noSmithyDocumentSerde
}

type UpdateDecoderManifestOutput struct {

	//  The Amazon Resource Name (ARN) of the updated decoder manifest.
	//
	// This member is required.
	Arn *string

	//  The name of the updated decoder manifest.
	//
	// This member is required.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDecoderManifestMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateDecoderManifest{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateDecoderManifest{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDecoderManifest"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDecoderManifestValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDecoderManifest(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDecoderManifest(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDecoderManifest",
	}
}
