// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a procurement portal preference configuration for e-invoice delivery
// and purchase order retrieval. This preference defines how invoices are delivered
// to a procurement portal and how purchase orders are retrieved.
func (c *Client) CreateProcurementPortalPreference(ctx context.Context, params *CreateProcurementPortalPreferenceInput, optFns ...func(*Options)) (*CreateProcurementPortalPreferenceOutput, error) {
	if params == nil {
		params = &CreateProcurementPortalPreferenceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProcurementPortalPreference", params, optFns, c.addOperationCreateProcurementPortalPreferenceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProcurementPortalPreferenceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProcurementPortalPreferenceInput struct {

	// The domain identifier for the buyer in the procurement portal.
	//
	// This member is required.
	BuyerDomain types.BuyerDomain

	// The unique identifier for the buyer in the procurement portal.
	//
	// This member is required.
	BuyerIdentifier *string

	// List of contact information for portal administrators and technical contacts
	// responsible for the e-invoice integration.
	//
	// This member is required.
	Contacts []types.Contact

	// Indicates whether e-invoice delivery is enabled for this procurement portal
	// preference. Set to true to enable e-invoice delivery, false to disable.
	//
	// This member is required.
	EinvoiceDeliveryEnabled *bool

	// The name of the procurement portal.
	//
	// This member is required.
	ProcurementPortalName types.ProcurementPortalName

	// Indicates whether purchase order retrieval is enabled for this procurement
	// portal preference. Set to true to enable PO retrieval, false to disable.
	//
	// This member is required.
	PurchaseOrderRetrievalEnabled *bool

	// The domain identifier for the supplier in the procurement portal.
	//
	// This member is required.
	SupplierDomain types.SupplierDomain

	// The unique identifier for the supplier in the procurement portal.
	//
	// This member is required.
	SupplierIdentifier *string

	// A unique, case-sensitive identifier that you provide to ensure idempotency of
	// the request.
	ClientToken *string

	// Specifies the e-invoice delivery configuration including document types,
	// attachment types, and customization settings for the portal.
	EinvoiceDeliveryPreference *types.EinvoiceDeliveryPreference

	// The endpoint URL where e-invoices will be delivered to the procurement portal.
	// Must be a valid HTTPS URL.
	ProcurementPortalInstanceEndpoint *string

	// The shared secret or authentication credential used to establish secure
	// communication with the procurement portal. This value must be encrypted at rest.
	ProcurementPortalSharedSecret *string

	// The tags to apply to this procurement portal preference resource. Each tag
	// consists of a key and an optional value.
	ResourceTags []types.ResourceTag

	// Specifies criteria for selecting which invoices should be processed using a
	// particular procurement portal preference.
	Selector *types.ProcurementPortalPreferenceSelector

	// Configuration settings for the test environment of the procurement portal.
	// Includes test credentials and endpoints that are used for validation before
	// production deployment.
	TestEnvPreference *types.TestEnvPreferenceInput

	noSmithyDocumentSerde
}

type CreateProcurementPortalPreferenceOutput struct {

	// The Amazon Resource Name (ARN) of the created procurement portal preference.
	//
	// This member is required.
	ProcurementPortalPreferenceArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProcurementPortalPreferenceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateProcurementPortalPreference{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateProcurementPortalPreference{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateProcurementPortalPreference"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateProcurementPortalPreferenceMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateProcurementPortalPreferenceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProcurementPortalPreference(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateProcurementPortalPreference struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateProcurementPortalPreference) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateProcurementPortalPreference) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateProcurementPortalPreferenceInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateProcurementPortalPreferenceInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateProcurementPortalPreferenceMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateProcurementPortalPreference{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateProcurementPortalPreference(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateProcurementPortalPreference",
	}
}
