// Code generated by smithy-go-codegen DO NOT EDIT.

package internetmonitor

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/internetmonitor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Start a query to return data for a specific query type for the Amazon
// CloudWatch Internet Monitor query interface. Specify a time period for the data
// that you want returned by using StartTime and EndTime . You filter the query
// results to return by providing parameters that you specify with FilterParameters
// .
//
// For more information about using the query interface, including examples, see [Using the Amazon CloudWatch Internet Monitor query interface]
// in the Amazon CloudWatch Internet Monitor User Guide.
//
// [Using the Amazon CloudWatch Internet Monitor query interface]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html
func (c *Client) StartQuery(ctx context.Context, params *StartQueryInput, optFns ...func(*Options)) (*StartQueryOutput, error) {
	if params == nil {
		params = &StartQueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartQuery", params, optFns, c.addOperationStartQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartQueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartQueryInput struct {

	// The timestamp that is the end of the period that you want to retrieve data for
	// with your query.
	//
	// This member is required.
	EndTime *time.Time

	// The name of the monitor to query.
	//
	// This member is required.
	MonitorName *string

	// The type of query to run. The following are the three types of queries that you
	// can run using the Internet Monitor query interface:
	//
	//   - MEASUREMENTS : Provides availability score, performance score, total
	//   traffic, and round-trip times, at 5 minute intervals.
	//
	//   - TOP_LOCATIONS : Provides availability score, performance score, total
	//   traffic, and time to first byte (TTFB) information, for the top location and ASN
	//   combinations that you're monitoring, by traffic volume.
	//
	//   - TOP_LOCATION_DETAILS : Provides TTFB for Amazon CloudFront, your current
	//   configuration, and the best performing EC2 configuration, at 1 hour intervals.
	//
	//   - OVERALL_TRAFFIC_SUGGESTIONS : Provides TTFB, using a 30-day weighted
	//   average, for all traffic in each Amazon Web Services location that is monitored.
	//
	//   - OVERALL_TRAFFIC_SUGGESTIONS_DETAILS : Provides TTFB, using a 30-day weighted
	//   average, for each top location, for a proposed Amazon Web Services location.
	//   Must provide an Amazon Web Services location to search.
	//
	//   - ROUTING_SUGGESTIONS : Provides the predicted average round-trip time (RTT)
	//   from an IP prefix toward an Amazon Web Services location for a DNS resolver. The
	//   RTT is calculated at one hour intervals, over a one hour period.
	//
	// For lists of the fields returned with each query type and more information
	// about how each type of query is performed, see [Using the Amazon CloudWatch Internet Monitor query interface]in the Amazon CloudWatch
	// Internet Monitor User Guide.
	//
	// [Using the Amazon CloudWatch Internet Monitor query interface]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html
	//
	// This member is required.
	QueryType types.QueryType

	// The timestamp that is the beginning of the period that you want to retrieve
	// data for with your query.
	//
	// This member is required.
	StartTime *time.Time

	// The FilterParameters field that you use with Amazon CloudWatch Internet Monitor
	// queries is a string the defines how you want a query to be filtered. The filter
	// parameters that you can specify depend on the query type, since each query type
	// returns a different set of Internet Monitor data.
	//
	// For more information about specifying filter parameters, see [Using the Amazon CloudWatch Internet Monitor query interface] in the Amazon
	// CloudWatch Internet Monitor User Guide.
	//
	// [Using the Amazon CloudWatch Internet Monitor query interface]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html
	FilterParameters []types.FilterParameter

	// The account ID for an account that you've set up cross-account sharing for in
	// Amazon CloudWatch Internet Monitor. You configure cross-account sharing by using
	// Amazon CloudWatch Observability Access Manager. For more information, see [Internet Monitor cross-account observability]in
	// the Amazon CloudWatch Internet Monitor User Guide.
	//
	// [Internet Monitor cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html
	LinkedAccountId *string

	noSmithyDocumentSerde
}

type StartQueryOutput struct {

	// The internally-generated identifier of a specific query.
	//
	// This member is required.
	QueryId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartQuery"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartQuery",
	}
}
