// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a code security scan configuration.
func (c *Client) GetCodeSecurityScanConfiguration(ctx context.Context, params *GetCodeSecurityScanConfigurationInput, optFns ...func(*Options)) (*GetCodeSecurityScanConfigurationOutput, error) {
	if params == nil {
		params = &GetCodeSecurityScanConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCodeSecurityScanConfiguration", params, optFns, c.addOperationGetCodeSecurityScanConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCodeSecurityScanConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCodeSecurityScanConfigurationInput struct {

	// The Amazon Resource Name (ARN) of the scan configuration to retrieve.
	//
	// This member is required.
	ScanConfigurationArn *string

	noSmithyDocumentSerde
}

type GetCodeSecurityScanConfigurationOutput struct {

	// The configuration settings for the code security scan.
	Configuration *types.CodeSecurityScanConfiguration

	// The timestamp when the scan configuration was created.
	CreatedAt *time.Time

	// The timestamp when the scan configuration was last updated.
	LastUpdatedAt *time.Time

	// The security level for the scan configuration.
	Level types.ConfigurationLevel

	// The name of the scan configuration.
	Name *string

	// The Amazon Resource Name (ARN) of the scan configuration.
	ScanConfigurationArn *string

	// The scope settings that define which repositories will be scanned. If the
	// ScopeSetting parameter is ALL the scan configuration applies to all existing
	// and future projects imported into Amazon Inspector.
	ScopeSettings *types.ScopeSettings

	// The tags associated with the scan configuration.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCodeSecurityScanConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCodeSecurityScanConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCodeSecurityScanConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCodeSecurityScanConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCodeSecurityScanConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCodeSecurityScanConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCodeSecurityScanConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCodeSecurityScanConfiguration",
	}
}
