// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a code security integration.
func (c *Client) GetCodeSecurityIntegration(ctx context.Context, params *GetCodeSecurityIntegrationInput, optFns ...func(*Options)) (*GetCodeSecurityIntegrationOutput, error) {
	if params == nil {
		params = &GetCodeSecurityIntegrationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCodeSecurityIntegration", params, optFns, c.addOperationGetCodeSecurityIntegrationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCodeSecurityIntegrationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCodeSecurityIntegrationInput struct {

	// The Amazon Resource Name (ARN) of the code security integration to retrieve.
	//
	// This member is required.
	IntegrationArn *string

	// The tags associated with the code security integration.
	Tags map[string]string

	noSmithyDocumentSerde
}

type GetCodeSecurityIntegrationOutput struct {

	// The timestamp when the code security integration was created.
	//
	// This member is required.
	CreatedOn *time.Time

	// The Amazon Resource Name (ARN) of the code security integration.
	//
	// This member is required.
	IntegrationArn *string

	// The timestamp when the code security integration was last updated.
	//
	// This member is required.
	LastUpdateOn *time.Time

	// The name of the code security integration.
	//
	// This member is required.
	Name *string

	// The current status of the code security integration.
	//
	// This member is required.
	Status types.IntegrationStatus

	// The reason for the current status of the code security integration.
	//
	// This member is required.
	StatusReason *string

	// The type of repository provider for the integration.
	//
	// This member is required.
	Type types.IntegrationType

	// The URL used to authorize the integration with the repository provider. This is
	// only returned if reauthorization is required to fix a connection issue.
	// Otherwise, it is null.
	AuthorizationUrl *string

	// The tags associated with the code security integration.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCodeSecurityIntegrationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCodeSecurityIntegration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCodeSecurityIntegration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCodeSecurityIntegration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCodeSecurityIntegrationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCodeSecurityIntegration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCodeSecurityIntegration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCodeSecurityIntegration",
	}
}
