// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a scan configuration for code security scanning.
func (c *Client) CreateCodeSecurityScanConfiguration(ctx context.Context, params *CreateCodeSecurityScanConfigurationInput, optFns ...func(*Options)) (*CreateCodeSecurityScanConfigurationOutput, error) {
	if params == nil {
		params = &CreateCodeSecurityScanConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCodeSecurityScanConfiguration", params, optFns, c.addOperationCreateCodeSecurityScanConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCodeSecurityScanConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCodeSecurityScanConfigurationInput struct {

	// The configuration settings for the code security scan.
	//
	// This member is required.
	Configuration *types.CodeSecurityScanConfiguration

	// The security level for the scan configuration.
	//
	// This member is required.
	Level types.ConfigurationLevel

	// The name of the scan configuration.
	//
	// This member is required.
	Name *string

	// The scope settings that define which repositories will be scanned. Include this
	// parameter to create a default scan configuration. Otherwise Amazon Inspector
	// creates a general scan configuration.
	//
	// A default scan configuration automatically applies to all existing and future
	// projects imported into Amazon Inspector. Use the
	// BatchAssociateCodeSecurityScanConfiguration operation to associate a general
	// scan configuration with projects.
	ScopeSettings *types.ScopeSettings

	// The tags to apply to the scan configuration.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateCodeSecurityScanConfigurationOutput struct {

	// The Amazon Resource Name (ARN) of the created scan configuration.
	//
	// This member is required.
	ScanConfigurationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCodeSecurityScanConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateCodeSecurityScanConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateCodeSecurityScanConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCodeSecurityScanConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateCodeSecurityScanConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCodeSecurityScanConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateCodeSecurityScanConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCodeSecurityScanConfiguration",
	}
}
