// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The filters applied to a data store query.
type DatastoreFilter struct {

	// Filter to set cutoff dates for records. All data stores created after the
	// specified date are included in the results.
	CreatedAfter *time.Time

	// Filter to set cutoff dates for records. All data stores created before the
	// specified date are included in the results.
	CreatedBefore *time.Time

	// Filter data store results by name.
	DatastoreName *string

	// Filter data store results by status.
	DatastoreStatus DatastoreStatus

	noSmithyDocumentSerde
}

// The data store properties.
type DatastoreProperties struct {

	// The Amazon Resource Name (ARN) used in the creation of the data store.
	//
	// This member is required.
	DatastoreArn *string

	// The AWS endpoint for the data store.
	//
	// This member is required.
	DatastoreEndpoint *string

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The data store status.
	//
	// This member is required.
	DatastoreStatus DatastoreStatus

	// The FHIR release version supported by the data store. Current support is for
	// version R4 .
	//
	// This member is required.
	DatastoreTypeVersion FHIRVersion

	// The time the data store was created.
	CreatedAt *time.Time

	// The data store name.
	DatastoreName *string

	// The error cause for the current data store operation.
	ErrorCause *ErrorCause

	// The identity provider selected during data store creation.
	IdentityProviderConfiguration *IdentityProviderConfiguration

	// The preloaded Synthea data configuration for the data store.
	PreloadDataConfig *PreloadDataConfig

	//  The server-side encryption key configuration for a customer provided
	// encryption key.
	SseConfiguration *SseConfiguration

	noSmithyDocumentSerde
}

// The error information for CreateFHIRDatastore and DeleteFHIRDatastore actions.
type ErrorCause struct {

	// The error category for ErrorCause .
	ErrorCategory ErrorCategory

	// The error message text for ErrorCause .
	ErrorMessage *string

	noSmithyDocumentSerde
}

// The properties of a FHIR export job.
type ExportJobProperties struct {

	// The data store identifier from which files are being exported.
	//
	// This member is required.
	DatastoreId *string

	// The export job identifier.
	//
	// This member is required.
	JobId *string

	// The export job status.
	//
	// This member is required.
	JobStatus JobStatus

	// The output data configuration supplied when the export job was created.
	//
	// This member is required.
	OutputDataConfig OutputDataConfig

	// The time the export job was initiated.
	//
	// This member is required.
	SubmitTime *time.Time

	// The Amazon Resource Name (ARN) used during the initiation of the export job.
	DataAccessRoleArn *string

	// The time the export job completed.
	EndTime *time.Time

	// The export job name.
	JobName *string

	// An explanation of any errors that might have occurred during the export job.
	Message *string

	noSmithyDocumentSerde
}

// The identity provider configuration selected when the data store was created.
type IdentityProviderConfiguration struct {

	// The authorization strategy selected when the HealthLake data store is created.
	//
	// HealthLake provides support for both SMART on FHIR V1 and V2 as described below.
	//
	//   - SMART_ON_FHIR_V1 – Support for only SMART on FHIR V1, which includes read
	//   (read/search) and write (create/update/delete) permissions.
	//
	//   - SMART_ON_FHIR – Support for both SMART on FHIR V1 and V2, which includes
	//   create , read , update , delete , and search permissions.
	//
	//   - AWS_AUTH – The default HealthLake authorization strategy; not affiliated
	//   with SMART on FHIR.
	//
	// This member is required.
	AuthorizationStrategy AuthorizationStrategy

	// The parameter to enable SMART on FHIR fine-grained authorization for the data
	// store.
	FineGrainedAuthorizationEnabled bool

	// The Amazon Resource Name (ARN) of the Lambda function to use to decode the
	// access token created by the authorization server.
	IdpLambdaArn *string

	// The JSON metadata elements to use in your identity provider configuration.
	// Required elements are listed based on the launch specification of the SMART
	// application. For more information on all possible elements, see [Metadata]in SMART's App
	// Launch specification.
	//
	// authorization_endpoint : The URL to the OAuth2 authorization endpoint.
	//
	// grant_types_supported : An array of grant types that are supported at the token
	// endpoint. You must provide at least one grant type option. Valid options are
	// authorization_code and client_credentials .
	//
	// token_endpoint : The URL to the OAuth2 token endpoint.
	//
	// capabilities : An array of strings of the SMART capabilities that the
	// authorization server supports.
	//
	// code_challenge_methods_supported : An array of strings of supported PKCE code
	// challenge methods. You must include the S256 method in the array of PKCE code
	// challenge methods.
	//
	// [Metadata]: https://build.fhir.org/ig/HL7/smart-app-launch/conformance.html#metadata
	Metadata *string

	noSmithyDocumentSerde
}

// The import job properties.
type ImportJobProperties struct {

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The input data configuration supplied when the import job was created.
	//
	// This member is required.
	InputDataConfig InputDataConfig

	// The import job identifier.
	//
	// This member is required.
	JobId *string

	// The import job status.
	//
	// This member is required.
	JobStatus JobStatus

	// The time the import job was submitted for processing.
	//
	// This member is required.
	SubmitTime *time.Time

	// The Amazon Resource Name (ARN) that grants AWS HealthLake access to the input
	// data.
	DataAccessRoleArn *string

	// The time the import job was completed.
	EndTime *time.Time

	// The import job name.
	JobName *string

	// The output data configuration supplied when the export job was created.
	JobOutputDataConfig OutputDataConfig

	// Displays the progress of the import job, including total resources scanned,
	// total resources imported, and total size of data imported.
	JobProgressReport *JobProgressReport

	// An explanation of any errors that might have occurred during the FHIR import
	// job.
	Message *string

	// The validation level of the import job.
	ValidationLevel ValidationLevel

	noSmithyDocumentSerde
}

//	The import job input properties.
//
// The following types satisfy this interface:
//
//	InputDataConfigMemberS3Uri
type InputDataConfig interface {
	isInputDataConfig()
}

// The S3Uri is the user-specified S3 location of the FHIR data to be imported
// into AWS HealthLake.
type InputDataConfigMemberS3Uri struct {
	Value string

	noSmithyDocumentSerde
}

func (*InputDataConfigMemberS3Uri) isInputDataConfig() {}

// The progress report for the import job.
type JobProgressReport struct {

	// The transaction rate the import job is processed at.
	Throughput *float64

	// The number of files that failed to be read from the S3 input bucket due to
	// customer error.
	TotalNumberOfFilesReadWithCustomerError *int64

	// The number of files imported.
	TotalNumberOfImportedFiles *int64

	// The number of resources imported.
	TotalNumberOfResourcesImported *int64

	// The number of resources scanned from the S3 input bucket.
	TotalNumberOfResourcesScanned *int64

	// The number of resources that failed due to customer error.
	TotalNumberOfResourcesWithCustomerError *int64

	// The number of files scanned from the S3 input bucket.
	TotalNumberOfScannedFiles *int64

	// The size (in MB) of files scanned from the S3 input bucket.
	TotalSizeOfScannedFilesInMB *float64

	noSmithyDocumentSerde
}

// The customer-managed-key (CMK) used when creating a data store. If a
// customer-owned key is not specified, an AWS-owned key is used for encryption.
type KmsEncryptionConfig struct {

	// The type of customer-managed-key (CMK) used for encryption.
	//
	// This member is required.
	CmkType CmkType

	// The Key Management Service (KMS) encryption key id/alias used to encrypt the
	// data store contents at rest.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The output data configuration supplied when the export job was created.
//
// The following types satisfy this interface:
//
//	OutputDataConfigMemberS3Configuration
type OutputDataConfig interface {
	isOutputDataConfig()
}

// The output data configuration supplied when the export job was created.
type OutputDataConfigMemberS3Configuration struct {
	Value S3Configuration

	noSmithyDocumentSerde
}

func (*OutputDataConfigMemberS3Configuration) isOutputDataConfig() {}

// The input properties for the preloaded (Synthea) data store.
type PreloadDataConfig struct {

	// The type of preloaded data. Only Synthea preloaded data is supported.
	//
	// This member is required.
	PreloadDataType PreloadDataType

	noSmithyDocumentSerde
}

// The configuration of the S3 bucket for either an import or export job. This
// includes assigning access permissions.
type S3Configuration struct {

	// The Key Management Service (KMS) key ID used to access the S3 bucket.
	//
	// This member is required.
	KmsKeyId *string

	// The S3Uri is the user-specified S3 location of the FHIR data to be imported
	// into AWS HealthLake.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The server-side encryption key configuration for a customer-provided encryption
// key.
type SseConfiguration struct {

	// The Key Management Service (KMS) encryption configuration used to provide
	// details for data encryption.
	//
	// This member is required.
	KmsEncryptionConfig *KmsEncryptionConfig

	noSmithyDocumentSerde
}

// A label consisting of a user-defined key and value. The form for tags is
// {"Key", "Value"}
type Tag struct {

	// The key portion of a tag. Tag keys are case sensitive.
	//
	// This member is required.
	Key *string

	//  The value portion of a tag. Tag values are case-sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isInputDataConfig()  {}
func (*UnknownUnionMember) isOutputDataConfig() {}
