// Code generated by smithy-go-codegen DO NOT EDIT.

package healthlake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/healthlake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// List all FHIR import jobs associated with an account and their statuses.
func (c *Client) ListFHIRImportJobs(ctx context.Context, params *ListFHIRImportJobsInput, optFns ...func(*Options)) (*ListFHIRImportJobsOutput, error) {
	if params == nil {
		params = &ListFHIRImportJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFHIRImportJobs", params, optFns, c.addOperationListFHIRImportJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFHIRImportJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFHIRImportJobsInput struct {

	// Limits the response to the import job with the specified data store ID.
	//
	// This member is required.
	DatastoreId *string

	// Limits the response to the import job with the specified job name.
	JobName *string

	// Limits the response to the import job with the specified job status.
	JobStatus types.JobStatus

	// Limits the number of results returned for ListFHIRImportJobs to a maximum
	// quantity specified by the user.
	MaxResults *int32

	// The pagination token used to identify the next page of results to return.
	NextToken *string

	// Limits the response to FHIR import jobs submitted after a user-specified date.
	SubmittedAfter *time.Time

	// Limits the response to FHIR import jobs submitted before a user- specified
	// date.
	SubmittedBefore *time.Time

	noSmithyDocumentSerde
}

type ListFHIRImportJobsOutput struct {

	// The properties for listed import jobs.
	//
	// This member is required.
	ImportJobPropertiesList []types.ImportJobProperties

	// The pagination token used to identify the next page of results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFHIRImportJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListFHIRImportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListFHIRImportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFHIRImportJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListFHIRImportJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFHIRImportJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListFHIRImportJobsPaginatorOptions is the paginator options for
// ListFHIRImportJobs
type ListFHIRImportJobsPaginatorOptions struct {
	// Limits the number of results returned for ListFHIRImportJobs to a maximum
	// quantity specified by the user.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFHIRImportJobsPaginator is a paginator for ListFHIRImportJobs
type ListFHIRImportJobsPaginator struct {
	options   ListFHIRImportJobsPaginatorOptions
	client    ListFHIRImportJobsAPIClient
	params    *ListFHIRImportJobsInput
	nextToken *string
	firstPage bool
}

// NewListFHIRImportJobsPaginator returns a new ListFHIRImportJobsPaginator
func NewListFHIRImportJobsPaginator(client ListFHIRImportJobsAPIClient, params *ListFHIRImportJobsInput, optFns ...func(*ListFHIRImportJobsPaginatorOptions)) *ListFHIRImportJobsPaginator {
	if params == nil {
		params = &ListFHIRImportJobsInput{}
	}

	options := ListFHIRImportJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFHIRImportJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFHIRImportJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFHIRImportJobs page.
func (p *ListFHIRImportJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFHIRImportJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFHIRImportJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFHIRImportJobsAPIClient is a client that implements the ListFHIRImportJobs
// operation.
type ListFHIRImportJobsAPIClient interface {
	ListFHIRImportJobs(context.Context, *ListFHIRImportJobsInput, ...func(*Options)) (*ListFHIRImportJobsOutput, error)
}

var _ ListFHIRImportJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFHIRImportJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFHIRImportJobs",
	}
}
