// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the detailed information for a specific malware scan. Each member
// account can view the malware scan details for their own account. An
// administrator can view malware scan details for all accounts in the
// organization.
//
// There might be regional differences because some data sources might not be
// available in all the Amazon Web Services Regions where GuardDuty is presently
// supported. For more information, see [Regions and endpoints].
//
// [Regions and endpoints]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html
func (c *Client) GetMalwareScan(ctx context.Context, params *GetMalwareScanInput, optFns ...func(*Options)) (*GetMalwareScanOutput, error) {
	if params == nil {
		params = &GetMalwareScanInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMalwareScan", params, optFns, c.addOperationGetMalwareScanMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMalwareScanOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMalwareScanInput struct {

	// A unique identifier that gets generated when you invoke the API without any
	// error. Each malware scan has a corresponding scan ID. Using this scan ID, you
	// can monitor the status of your malware scan.
	//
	// This member is required.
	ScanId *string

	noSmithyDocumentSerde
}

type GetMalwareScanOutput struct {

	// The unique detector ID of the administrator account that the request is
	// associated with. If the account is an administrator, the AdminDetectorId will
	// be the same as the one used for DetectorId. If the customer is not a GuardDuty
	// customer, this field will not be present. .
	//
	// To find the detectorId in the current Region, see the Settings page in the
	// GuardDuty console, or run the [ListDetectors]API.
	//
	// [ListDetectors]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html
	AdminDetectorId *string

	// The unique ID of the detector that is associated with the request, if it
	// belongs to an account which is a GuardDuty customer.
	//
	// To find the detectorId in the current Region, see the Settings page in the
	// GuardDuty console, or run the [ListDetectors]API.
	//
	// [ListDetectors]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html
	DetectorId *string

	// The total number of resources that failed to be scanned.
	FailedResourcesCount *int32

	// Amazon Resource Name (ARN) of the resource on which a malware scan was invoked.
	ResourceArn *string

	// The type of resource that was scanned for malware.
	ResourceType types.MalwareProtectionResourceType

	// The category of the malware scan, indicating the type of scan performed.
	ScanCategory types.ScanCategory

	// The timestamp representing when the malware scan was completed.
	ScanCompletedAt *time.Time

	// Information about the scan configuration used for the malware scan.
	ScanConfiguration *types.ScanConfiguration

	// A unique identifier associated with the malware scan. Each malware scan has a
	// corresponding scan ID. Using this scan ID, you can monitor the status of your
	// malware scan.
	ScanId *string

	// Detailed information about the results of the malware scan, if the scan
	// completed.
	ScanResultDetails *types.GetMalwareScanResultDetails

	// The timestamp representing when the malware scan was started.
	ScanStartedAt *time.Time

	// A value representing the current status of the malware scan.
	ScanStatus types.MalwareProtectionScanStatus

	// Represents the reason for the current scan status, if applicable.
	ScanStatusReason types.ScanStatusReason

	// A value representing the initiator of the scan.
	ScanType types.MalwareProtectionScanType

	// A list of resources along with their metadata that were scanned as part of the
	// malware scan operation.
	ScannedResources []types.ScannedResource

	// The total number of resources that were successfully scanned. This is dependent
	// on the resource type.
	ScannedResourcesCount *int32

	// The total number of resources that were skipped during the scan.
	SkippedResourcesCount *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMalwareScanMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMalwareScan{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMalwareScan{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMalwareScan"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetMalwareScanValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMalwareScan(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMalwareScan(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMalwareScan",
	}
}
