// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new trusted entity set. In the trusted entity set, you can provide IP
// addresses and domains that you believe are secure for communication in your
// Amazon Web Services environment. GuardDuty will not generate findings for the
// entries that are specified in a trusted entity set. At any given time, you can
// have only one trusted entity set.
//
// Only users of the administrator account can manage the entity sets, which
// automatically apply to member accounts.
func (c *Client) CreateTrustedEntitySet(ctx context.Context, params *CreateTrustedEntitySetInput, optFns ...func(*Options)) (*CreateTrustedEntitySetOutput, error) {
	if params == nil {
		params = &CreateTrustedEntitySetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTrustedEntitySet", params, optFns, c.addOperationCreateTrustedEntitySetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTrustedEntitySetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateTrustedEntitySetInput struct {

	// A boolean value that indicates whether GuardDuty is to start using the uploaded
	// trusted entity set.
	//
	// This member is required.
	Activate *bool

	// The unique ID of the detector of the GuardDuty account for which you want to
	// create a trusted entity set.
	//
	// To find the detectorId in the current Region, see the Settings page in the
	// GuardDuty console, or run the [ListDetectors]API.
	//
	// [ListDetectors]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html
	//
	// This member is required.
	DetectorId *string

	// The format of the file that contains the trusted entity set.
	//
	// This member is required.
	Format types.TrustedEntitySetFormat

	// The URI of the file that contains the threat entity set. The format of the
	// Location URL must be a valid Amazon S3 URL format. Invalid URL formats will
	// result in an error, regardless of whether you activate the entity set or not.
	// For more information about format of the location URLs, see [Format of location URL under Step 2: Adding trusted or threat intelligence data]in the Amazon
	// GuardDuty User Guide.
	//
	// [Format of location URL under Step 2: Adding trusted or threat intelligence data]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty-lists-create-activate.html
	//
	// This member is required.
	Location *string

	// A user-friendly name to identify the trusted entity set.
	//
	// The name of your list can include lowercase letters, uppercase letters,
	// numbers, dash (-), and underscore (_).
	//
	// This member is required.
	Name *string

	// The idempotency token for the create request.
	ClientToken *string

	// The Amazon Web Services account ID that owns the Amazon S3 bucket specified in
	// the location parameter.
	ExpectedBucketOwner *string

	// The tags to be added to a new trusted entity set resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateTrustedEntitySetOutput struct {

	// The ID returned by GuardDuty after creation of the trusted entity set resource.
	//
	// This member is required.
	TrustedEntitySetId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTrustedEntitySetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateTrustedEntitySet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateTrustedEntitySet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTrustedEntitySet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateTrustedEntitySetMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateTrustedEntitySetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTrustedEntitySet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateTrustedEntitySet struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateTrustedEntitySet) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateTrustedEntitySet) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateTrustedEntitySetInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateTrustedEntitySetInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateTrustedEntitySetMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateTrustedEntitySet{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateTrustedEntitySet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTrustedEntitySet",
	}
}
