// Code generated by smithy-go-codegen DO NOT EDIT.

package groundstation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/groundstation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieve information about an existing ephemeris.
func (c *Client) DescribeEphemeris(ctx context.Context, params *DescribeEphemerisInput, optFns ...func(*Options)) (*DescribeEphemerisOutput, error) {
	if params == nil {
		params = &DescribeEphemerisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeEphemeris", params, optFns, c.addOperationDescribeEphemerisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeEphemerisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeEphemerisInput struct {

	// The AWS Ground Station ephemeris ID.
	//
	// This member is required.
	EphemerisId *string

	noSmithyDocumentSerde
}

type DescribeEphemerisOutput struct {

	// The time the ephemeris was uploaded in UTC.
	CreationTime *time.Time

	// Whether or not the ephemeris is enabled.
	Enabled *bool

	// The AWS Ground Station ephemeris ID.
	EphemerisId *string

	// Detailed error information for ephemerides with INVALID status.
	//
	// Provides specific error codes and messages to help diagnose validation failures.
	ErrorReasons []types.EphemerisErrorReason

	// Reason that an ephemeris failed validation. Appears only when the status is
	// INVALID .
	InvalidReason types.EphemerisInvalidReason

	// A name that you can use to identify the ephemeris.
	Name *string

	// A priority score that determines which ephemeris to use when multiple
	// ephemerides overlap.
	//
	// Higher numbers take precedence. The default is 1. Must be 1 or greater.
	Priority *int32

	// The AWS Ground Station satellite ID associated with ephemeris.
	SatelliteId *string

	// The status of the ephemeris.
	Status types.EphemerisStatus

	// Supplied ephemeris data.
	SuppliedData types.EphemerisTypeDescription

	// Tags assigned to an ephemeris.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeEphemerisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeEphemeris{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeEphemeris{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeEphemeris"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeEphemerisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeEphemeris(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeEphemeris(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeEphemeris",
	}
}
