// Code generated by smithy-go-codegen DO NOT EDIT.

package groundstation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/groundstation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Create an ephemeris with your specified EphemerisData.
func (c *Client) CreateEphemeris(ctx context.Context, params *CreateEphemerisInput, optFns ...func(*Options)) (*CreateEphemerisOutput, error) {
	if params == nil {
		params = &CreateEphemerisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEphemeris", params, optFns, c.addOperationCreateEphemerisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEphemerisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEphemerisInput struct {

	// A name that you can use to identify the ephemeris.
	//
	// This member is required.
	Name *string

	// Set to true to enable the ephemeris after validation. Set to false to keep it
	// disabled.
	Enabled *bool

	// Ephemeris data.
	Ephemeris types.EphemerisData

	// An overall expiration time for the ephemeris in UTC, after which it will become
	// EXPIRED .
	ExpirationTime *time.Time

	// The ARN of the KMS key to use for encrypting the ephemeris.
	KmsKeyArn *string

	// A priority score that determines which ephemeris to use when multiple
	// ephemerides overlap.
	//
	// Higher numbers take precedence. The default is 1. Must be 1 or greater.
	Priority *int32

	// The satellite ID that associates this ephemeris with a satellite in AWS Ground
	// Station.
	SatelliteId *string

	// Tags assigned to an ephemeris.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateEphemerisOutput struct {

	// The AWS Ground Station ephemeris ID.
	EphemerisId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEphemerisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateEphemeris{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateEphemeris{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEphemeris"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEphemerisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEphemeris(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateEphemeris(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEphemeris",
	}
}
