// Code generated by smithy-go-codegen DO NOT EDIT.

package groundstation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/groundstation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a DataflowEndpointGroupV2 containing the specified list of
// DataflowEndpoint objects.
//
// The name field in each endpoint is used in your mission profile
// DataflowEndpointConfig to specify which endpoints to use during a contact.
//
// When a contact uses multiple DataflowEndpointConfig objects, each Config must
// match a DataflowEndpoint in the same group.
func (c *Client) CreateDataflowEndpointGroupV2(ctx context.Context, params *CreateDataflowEndpointGroupV2Input, optFns ...func(*Options)) (*CreateDataflowEndpointGroupV2Output, error) {
	if params == nil {
		params = &CreateDataflowEndpointGroupV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataflowEndpointGroupV2", params, optFns, c.addOperationCreateDataflowEndpointGroupV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataflowEndpointGroupV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataflowEndpointGroupV2Input struct {

	// Dataflow endpoint group's endpoint definitions
	//
	// This member is required.
	Endpoints []types.CreateEndpointDetails

	// Amount of time, in seconds, after a contact ends that the Ground Station
	// Dataflow Endpoint Group will be in a POSTPASS state. A Ground Station Dataflow
	// Endpoint Group State Change event will be emitted when the Dataflow Endpoint
	// Group enters and exits the POSTPASS state.
	ContactPostPassDurationSeconds *int32

	// Amount of time, in seconds, before a contact starts that the Ground Station
	// Dataflow Endpoint Group will be in a PREPASS state. A Ground Station Dataflow
	// Endpoint Group State Change event will be emitted when the Dataflow Endpoint
	// Group enters and exits the PREPASS state.
	ContactPrePassDurationSeconds *int32

	// Tags of a V2 dataflow endpoint group.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateDataflowEndpointGroupV2Output struct {

	// Dataflow endpoint group ID
	DataflowEndpointGroupId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataflowEndpointGroupV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDataflowEndpointGroupV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDataflowEndpointGroupV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataflowEndpointGroupV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDataflowEndpointGroupV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataflowEndpointGroupV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataflowEndpointGroupV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataflowEndpointGroupV2",
	}
}
