// Code generated by smithy-go-codegen DO NOT EDIT.

package georoutes

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/georoutes/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use the CalculateIsolines action to find service areas that can be reached in a
// given threshold of time, distance.
func (c *Client) CalculateIsolines(ctx context.Context, params *CalculateIsolinesInput, optFns ...func(*Options)) (*CalculateIsolinesOutput, error) {
	if params == nil {
		params = &CalculateIsolinesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CalculateIsolines", params, optFns, c.addOperationCalculateIsolinesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CalculateIsolinesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CalculateIsolinesInput struct {

	// Threshold to be used for the isoline calculation. Up to 3 thresholds per
	// provided type can be requested.
	//
	// You incur a calculation charge for each threshold. Using a large amount of
	// thresholds in a request can lead you to incur unexpected charges. See [Amazon Location's pricing page]for more
	// information.
	//
	// [Amazon Location's pricing page]: https://docs.aws.amazon.com/location/latest/developerguide/routes-pricing.html`
	//
	// This member is required.
	Thresholds *types.IsolineThresholds

	// Features that are allowed while calculating an isoline.
	Allow *types.IsolineAllowOptions

	// Time of arrival at the destination.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	ArrivalTime *string

	// Features that are avoided while calculating a route. Avoidance is on a
	// best-case basis. If an avoidance can't be satisfied for a particular case, it
	// violates the avoidance and the returned response produces a notice for the
	// violation.
	Avoid *types.IsolineAvoidanceOptions

	// Uses the current time as the time of departure.
	DepartNow *bool

	// Time of departure from thr origin.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	DepartureTime *string

	// The final position for the route. In the World Geodetic System (WGS 84) format:
	// [longitude, latitude] .
	Destination []float64

	// Destination related options.
	DestinationOptions *types.IsolineDestinationOptions

	// The format of the returned IsolineGeometry.
	//
	// Default Value: FlexiblePolyline
	IsolineGeometryFormat types.GeometryFormat

	// Defines the granularity of the returned Isoline.
	IsolineGranularity *types.IsolineGranularityOptions

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// Specifies the optimization criteria for when calculating an isoline.
	// AccurateCalculation generates an isoline of higher granularity that is more
	// precise. FastCalculation generates an isoline faster by reducing the
	// granularity, and in turn the quality of the isoline. BalancedCalculation
	// generates an isoline by balancing between quality and performance.
	//
	// Default Value: BalancedCalculation
	OptimizeIsolineFor types.IsolineOptimizationObjective

	// Specifies the optimization criteria for calculating a route.
	//
	// Default Value: FastestRoute
	OptimizeRoutingFor types.RoutingObjective

	// The start position for the route.
	Origin []float64

	// Origin related options.
	OriginOptions *types.IsolineOriginOptions

	// Traffic related options.
	Traffic *types.IsolineTrafficOptions

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility.
	//
	// The mode Scooter also applies to motorcycles, set to Scooter when wanted to
	// calculate options for motorcycles.
	//
	// Default Value: Car
	TravelMode types.IsolineTravelMode

	// Travel mode related options for the provided travel mode.
	TravelModeOptions *types.IsolineTravelModeOptions

	noSmithyDocumentSerde
}

type CalculateIsolinesOutput struct {

	// The format of the returned IsolineGeometry.
	//
	// Default Value: FlexiblePolyline
	//
	// This member is required.
	IsolineGeometryFormat types.GeometryFormat

	// Calculated isolines and associated properties.
	//
	// This member is required.
	Isolines []types.Isoline

	// The pricing bucket for which the query is charged at.
	//
	// This member is required.
	PricingBucket *string

	// Time of arrival at the destination. This parameter is returned only if the
	// Destination parameters was provided in the request.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	ArrivalTime *string

	// Time of departure from thr origin.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	DepartureTime *string

	// Snapped destination that was used for the Isoline calculation.
	SnappedDestination []float64

	// Snapped origin that was used for the Isoline calculation.
	SnappedOrigin []float64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCalculateIsolinesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCalculateIsolines{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCalculateIsolines{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CalculateIsolines"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCalculateIsolinesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCalculateIsolines(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCalculateIsolines(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CalculateIsolines",
	}
}
