// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Position of the access point represented by longitude and latitude for a
// vehicle.
type AccessPoint struct {

	// The position, in longitude and latitude.
	Position []float64

	noSmithyDocumentSerde
}

// Indicates if the access location is restricted. Index correlates to that of an
// access point and indicates if access through this point has some form of
// restriction.
type AccessRestriction struct {

	// Categories of results that results must belong too.
	Categories []Category

	// The restriction.
	Restricted *bool

	noSmithyDocumentSerde
}

// The place address.
type Address struct {

	// The number that identifies an address within a street.
	AddressNumber *string

	// Name of the block.
	//
	// Example: Sunny Mansion 203 block: 2 Chome
	Block *string

	// The name of the building at the address.
	Building *string

	// The country component of the address.
	Country *Country

	// The district or division of a locality associated with this address.
	District *string

	// Name of the streets in the intersection.
	//
	// Example: ["Friedrichstraße","Unter den Linden"]
	Intersection []string

	// Assembled address value built out of the address components, according to the
	// regional postal rules. This is the correctly formatted address.
	Label *string

	// The city or locality of the address.
	//
	// Example: Vancouver .
	Locality *string

	// An alphanumeric string included in a postal address to facilitate mail sorting,
	// such as post code, postcode, or ZIP code, for which the result should possess.
	PostalCode *string

	// The region or state results should be present in.
	//
	// Example: North Rhine-Westphalia .
	Region *Region

	// Components that correspond to secondary identifiers on an Address. Secondary
	// address components include information such as Suite or Unit Number, Building,
	// or Floor.
	SecondaryAddressComponents []SecondaryAddressComponent

	// The name of the street results should be present in.
	Street *string

	// Components of the street.
	//
	// Example: Younge from the "Younge street".
	StreetComponents []StreetComponents

	// Name of sub-block.
	//
	// Example: Sunny Mansion 203 sub-block: 4
	SubBlock *string

	// A subdivision of a district.
	//
	// Example: Minden-Lübbecke .
	SubDistrict *string

	// The sub-region or county for which results should be present in.
	SubRegion *SubRegion

	noSmithyDocumentSerde
}

// Indicates how well the entire input matches the returned. It is equal to 1 if
// all input tokens are recognized and matched.
type AddressComponentMatchScores struct {

	// The house number or address results should have.
	AddressNumber float64

	// Name of the block.
	//
	// Example: Sunny Mansion 203 block: 2 Chome
	Block float64

	// The name of the building at the address.
	Building float64

	// The alpha-2 or alpha-3 character code for the country that the results will be
	// present in.
	Country float64

	// The district or division of a city the results should be present in.
	District float64

	// Name of the streets in the intersection.
	//
	// Example: ["Friedrichstraße","Unter den Linden"]
	Intersection []float64

	// The city or locality results should be present in.
	//
	// Example: Vancouver .
	Locality float64

	// An alphanumeric string included in a postal address to facilitate mail sorting,
	// such as post code, postcode, or ZIP code, for which the result should possess.
	PostalCode float64

	// The region or state results should be to be present in.
	//
	// Example: North Rhine-Westphalia .
	Region float64

	// Match scores for the secondary address components in the result.
	SecondaryAddressComponents []SecondaryAddressComponentMatchScore

	// Name of sub-block.
	//
	// Example: Sunny Mansion 203 sub-block: 4
	SubBlock float64

	// A subdivision of a district.
	//
	// Example: Minden-Lübbecke
	SubDistrict float64

	// The sub-region or county for which results should be present in.
	SubRegion float64

	noSmithyDocumentSerde
}

// How to pronounce the various components of the address or place.
type AddressComponentPhonemes struct {

	// How to pronounce the name of the block.
	Block []PhonemeTranscription

	// The alpha-2 or alpha-3 character code for the country that the results will be
	// present in.
	Country []PhonemeTranscription

	// How to pronounce the district or division of a city results should be present
	// in.
	District []PhonemeTranscription

	// How to pronounce the city or locality results should be present in.
	//
	// Example: Vancouver .
	Locality []PhonemeTranscription

	// How to pronounce the region or state results should be to be present in.
	Region []PhonemeTranscription

	// How to pronounce the name of the street results should be present in.
	Street []PhonemeTranscription

	// How to pronounce the name of the sub-block.
	SubBlock []PhonemeTranscription

	// How to pronounce the sub-district or division of a city results should be
	// present in.
	SubDistrict []PhonemeTranscription

	// How to pronounce the sub-region or county for which results should be present
	// in.
	SubRegion []PhonemeTranscription

	noSmithyDocumentSerde
}

// Describes how the parts of the response element matched the input query by
// returning the sections of the response which matched to input query terms.
type AutocompleteAddressHighlights struct {

	// The house number or address results should have.
	AddressNumber []Highlight

	// Name of the block.
	//
	// Example: Sunny Mansion 203 block: 2 Chome
	Block []Highlight

	// The name of the building at the address.
	Building []Highlight

	// The alpha-2 or alpha-3 character code for the country that the results will be
	// present in.
	Country *CountryHighlights

	// The district or division of a city the results should be present in.
	District []Highlight

	// Name of the streets in the intersection. For example: e.g.
	// ["Friedrichstraße","Unter den Linden"]
	Intersection [][]Highlight

	// Indicates the starting and ending indexes for result items where they are
	// identified to match the input query. This should be used to provide emphasis to
	// output display to make selecting the correct result from a list easier for end
	// users.
	Label []Highlight

	// The city or locality results should be present in.
	//
	// Example: Vancouver .
	Locality []Highlight

	// An alphanumeric string included in a postal address to facilitate mail sorting,
	// such as post code, postcode, or ZIP code for which the result should possess.
	PostalCode []Highlight

	// The region or state results should be to be present in.
	//
	// Example: North Rhine-Westphalia .
	Region *RegionHighlights

	// The name of the street results should be present in.
	Street []Highlight

	// Name of sub-block.
	//
	// Example: Sunny Mansion 203 sub-block: 4
	SubBlock []Highlight

	// Indicates the starting and ending index of the title in the text query that
	// match the found title.
	SubDistrict []Highlight

	// The sub-region or county for which results should be present in.
	SubRegion *SubRegionHighlights

	noSmithyDocumentSerde
}

// Autocomplete structure which contains a set of inclusion/exclusion properties
// that results must possess in order to be returned as a result.
type AutocompleteFilter struct {

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	BoundingBox []float64

	// The Circle that all results must be in.
	Circle *FilterCircle

	//  A list of countries that all results must be in. Countries are represented by
	// either their alpha-2 or alpha-3 character codes.
	IncludeCountries []string

	// The included place types.
	IncludePlaceTypes []AutocompleteFilterPlaceType

	noSmithyDocumentSerde
}

// Describes how the parts of the response element matched the input query by
// returning the sections of the response which matched to input query terms.
type AutocompleteHighlights struct {

	// Describes how part of the result address match the input query.
	Address *AutocompleteAddressHighlights

	// Indicates where the title field in the result matches the input query.
	Title []Highlight

	noSmithyDocumentSerde
}

// A result matching the input query text.
type AutocompleteResultItem struct {

	// The PlaceId of the place associated with this result. This can be used to look
	// up additional details about the result via GetPlace.
	//
	// This member is required.
	PlaceId *string

	// PlaceType describes the type of result entry returned.
	//
	// This member is required.
	PlaceType PlaceType

	// A formatted string for display when presenting this result to an end user.
	//
	// This member is required.
	Title *string

	// The address associated with this result.
	Address *Address

	// The distance in meters between the center of the search area and this result.
	// Useful to evaluate how far away from the original bias position the result is.
	Distance int64

	// Indicates the starting and ending index of the place in the text query that
	// match the found title.
	Highlights *AutocompleteHighlights

	// A list of [BCP 47] compliant language codes for the results to be rendered in. If there
	// is no data for the result in the requested language, data will be returned in
	// the default language for the entry.
	//
	// [BCP 47]: https://en.wikipedia.org/wiki/IETF_language_tag
	Language *string

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	noSmithyDocumentSerde
}

// A businesschain is a chain of businesses that belong to the same brand. For
// example 7-11 .
type BusinessChain struct {

	// The Business Chain Id.
	Id *string

	// The business chain name.
	Name *string

	noSmithyDocumentSerde
}

// Category of the Place returned.
type Category struct {

	// The category ID.
	//
	// This member is required.
	Id *string

	// The category name.
	//
	// This member is required.
	Name *string

	// Localized name of the category type.
	LocalizedName *string

	// Boolean which indicates if this category is the primary offered by the place.
	Primary *bool

	noSmithyDocumentSerde
}

// Indicates how well the returned title and address components matches the input
// TextQuery. For each component a score is provied with 1 indicating all tokens
// were matched and 0 indicating no tokens were matched.
type ComponentMatchScores struct {

	// The place's address.
	Address *AddressComponentMatchScores

	// Indicates the match score of the title in the text query that match the found
	// title.
	Title float64

	noSmithyDocumentSerde
}

// Details related to contacts.
type ContactDetails struct {

	// Categories of results that results must belong too.
	Categories []Category

	// The contact's label.
	Label *string

	// The contact's value.
	Value *string

	noSmithyDocumentSerde
}

// A list of potential contact methods for the result/place.
type Contacts struct {

	// List of emails for contacts of the result.
	Emails []ContactDetails

	// List of fax addresses for the result contact.
	Faxes []ContactDetails

	// List of phone numbers for the results contact.
	Phones []ContactDetails

	// List of website URLs that belong to the result.
	Websites []ContactDetails

	noSmithyDocumentSerde
}

// The alpha-2 or alpha-3 character code for the country that the results will be
// present in.
type Country struct {

	// Country, represented by its alpha 2-character code.
	Code2 *string

	// Country, represented by its alpha t-character code.
	Code3 *string

	// Name of the country.
	Name *string

	noSmithyDocumentSerde
}

// Indicates the starting and ending index of the country in the text query that
// match the found title.
type CountryHighlights struct {

	// Indicates the starting and ending index of the country code in the text query
	// that match the found title.
	Code []Highlight

	// Indicates the starting and ending index of the country code in the text query
	// that match the found title.
	Name []Highlight

	noSmithyDocumentSerde
}

// The Circle that all results must be in.
type FilterCircle struct {

	// The center position, in longitude and latitude, of the FilterCircle .
	//
	// This member is required.
	Center []float64

	// The radius, in meters, of the FilterCircle .
	//
	// This member is required.
	Radius *int64

	noSmithyDocumentSerde
}

// List of Food types offered by this result.
type FoodType struct {

	// Localized name of the food type.
	//
	// This member is required.
	LocalizedName *string

	// The Food Type Id.
	Id *string

	// Boolean which indicates if this food type is the primary offered by the place.
	// For example, if a location serves fast food, but also dessert, he primary would
	// likely be fast food.
	Primary *bool

	noSmithyDocumentSerde
}

// Geocode structure which contains a set of inclusion/exclusion properties that
// results must possess in order to be returned as a result.
type GeocodeFilter struct {

	//  A list of countries that all results must be in. Countries are represented by
	// either their alpha-2 or alpha-3 character codes.
	IncludeCountries []string

	// The included place types.
	IncludePlaceTypes []GeocodeFilterPlaceType

	noSmithyDocumentSerde
}

// Parsed components in the provided QueryText.
type GeocodeParsedQuery struct {

	// The place address.
	Address *GeocodeParsedQueryAddressComponents

	// The localized display name of this result item based on request parameter
	// language .
	Title []ParsedQueryComponent

	noSmithyDocumentSerde
}

// Parsed address components in the provided QueryText.
type GeocodeParsedQueryAddressComponents struct {

	// The number that identifies an address within a street.
	AddressNumber []ParsedQueryComponent

	// Name of the block.
	//
	// Example: Sunny Mansion 203 block: 2 Chome
	Block []ParsedQueryComponent

	// The name of the building at the address.
	Building []ParsedQueryComponent

	// The alpha-2 or alpha-3 character code for the country that the results will be
	// present in.
	Country []ParsedQueryComponent

	// The district or division of a city the results should be present in.
	District []ParsedQueryComponent

	// The city or locality of the address.
	//
	// Example: Vancouver .
	Locality []ParsedQueryComponent

	// An alphanumeric string included in a postal address to facilitate mail sorting,
	// such as post code, postcode, or ZIP code, for which the result should possess.
	PostalCode []ParsedQueryComponent

	// The region or state results should be present in.
	//
	// Example: North Rhine-Westphalia .
	Region []ParsedQueryComponent

	// Parsed secondary address components from the provided query text.
	SecondaryAddressComponents []ParsedQuerySecondaryAddressComponent

	// The name of the street results should be present in.
	Street []ParsedQueryComponent

	// Name of sub-block.
	//
	// Example: Sunny Mansion 203 sub-block: 4
	SubBlock []ParsedQueryComponent

	// A subdivision of a district.
	//
	// Example: Minden-Lübbecke .
	SubDistrict []ParsedQueryComponent

	// The sub-region or county for which results should be present in.
	SubRegion []ParsedQueryComponent

	noSmithyDocumentSerde
}

// A structured free text query allows you to search for places by the name or
// text representation of specific properties of the place.
type GeocodeQueryComponents struct {

	// The house number or address results should have.
	AddressNumber *string

	// The alpha-2 or alpha-3 character code for the country that the results will be
	// present in.
	Country *string

	// The district or division of a city the results should be present in.
	District *string

	// The city or locality results should be present in.
	//
	// Example: Vancouver .
	Locality *string

	// An alphanumeric string included in a postal address to facilitate mail sorting,
	// such as post code, postcode, or ZIP code for which the result should possess.
	PostalCode *string

	// The region or state results should be to be present in.
	//
	// Example: North Rhine-Westphalia .
	Region *string

	// The name of the street results should be present in.
	Street *string

	// The sub-region or county for which results should be present in.
	SubRegion *string

	noSmithyDocumentSerde
}

// The Geocoded result.
type GeocodeResultItem struct {

	// The PlaceId of the place result.
	//
	// This member is required.
	PlaceId *string

	// A PlaceType is a category that the result place must belong to.
	//
	// This member is required.
	PlaceType PlaceType

	// The localized display name of this result item based on request parameter
	// language .
	//
	// This member is required.
	Title *string

	// Position of the access point represented by longitude and latitude.
	AccessPoints []AccessPoint

	// The place's address.
	Address *Address

	// Boolean indicating if the address provided has been corrected.
	AddressNumberCorrected *bool

	// Categories of results that results must belong to.
	Categories []Category

	// The distance in meters from the QueryPosition.
	Distance int64

	// List of food types offered by this result.
	FoodTypes []FoodType

	// All Intersections that are near the provided address.
	Intersections []Intersection

	// The main address corresponding to a place of type Secondary Address.
	MainAddress *RelatedPlace

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	MapView []float64

	// Indicates how well the entire input matches the returned. It is equal to 1 if
	// all input tokens are recognized and matched.
	MatchScores *MatchScoreDetails

	// Free-form text query.
	ParsedQuery *GeocodeParsedQuery

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// The position in longitude and latitude.
	Position []float64

	// Contains details about the postal code of the place/result.
	PostalCodeDetails []PostalCodeDetails

	// All secondary addresses that are associated with a main address. A secondary
	// address is one that includes secondary designators, such as a Suite or Unit
	// Number, Building, or Floor information.
	SecondaryAddresses []RelatedPlace

	// The time zone in which the place is located.
	TimeZone *TimeZone

	noSmithyDocumentSerde
}

// Indicates the starting and ending index of the text query that match the found
// title.
type Highlight struct {

	// End index of the highlight.
	EndIndex *int32

	// Start index of the highlight.
	StartIndex *int32

	// The highlight's value.
	Value *string

	noSmithyDocumentSerde
}

// All Intersections that are near the provided address.
type Intersection struct {

	// The PlaceId of the place result.
	//
	// This member is required.
	PlaceId *string

	// The localized display name of this result item based on request parameter
	// language .
	//
	// This member is required.
	Title *string

	// Position of the access point represented by longitude and latitude.
	AccessPoints []AccessPoint

	// The place address.
	Address *Address

	// The distance in meters from the QueryPosition.
	Distance *int64

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set of four coordinates: [{westward
	// lng}, {southern lat}, {eastward lng}, {northern lat}]
	MapView []float64

	// The position, in longitude and latitude.
	Position []float64

	// The distance from the routing position of the nearby address to the street
	// result.
	RouteDistance *int64

	noSmithyDocumentSerde
}

// Details related to the match score.
type MatchScoreDetails struct {

	// Indicates how well the component input matches the returned. It is equal to 1
	// if all input tokens are recognized and matched.
	Components *ComponentMatchScores

	// Indicates how well the entire input matches the returned. It is equal to 1 if
	// all input tokens are recognized and matched.
	Overall float64

	noSmithyDocumentSerde
}

// List of opening hours objects.
type OpeningHours struct {

	// Categories of results that results must belong too.
	Categories []Category

	// Components of the opening hours object.
	Components []OpeningHoursComponents

	// List of opening hours in the format they are displayed in. This can vary by
	// result and in most cases represents how the result uniquely formats their
	// opening hours.
	Display []string

	// Boolean which indicates if the result/place is currently open.
	OpenNow *bool

	noSmithyDocumentSerde
}

// Components of the opening hours object.
type OpeningHoursComponents struct {

	// String which represents the duration of the opening period, such as "PT12H00M" .
	OpenDuration *string

	// String which represents the opening hours, such as "T070000" .
	OpenTime *string

	// Days or periods when the provided opening hours are in affect.
	//
	// Example: FREQ:DAILY;BYDAY:MO,TU,WE,TH,SU
	Recurrence *string

	noSmithyDocumentSerde
}

// Parsed components in the provided QueryText.
type ParsedQueryComponent struct {

	// End index of the parsed query component.
	EndIndex *int32

	// The address component that the parsed query component corresponds to.
	QueryComponent *string

	// Start index of the parsed query component.
	StartIndex *int32

	// Value of the parsed query component.
	Value *string

	noSmithyDocumentSerde
}

// Information about a secondary address component parsed from the query text.
type ParsedQuerySecondaryAddressComponent struct {

	// Secondary address designator provided in the query.
	//
	// This member is required.
	Designator *string

	// End index of the parsed secondary address component in the query text.
	//
	// This member is required.
	EndIndex *int32

	// Secondary address number provided in the query.
	//
	// This member is required.
	Number *string

	// Start index of the parsed secondary address component in the query text.
	//
	// This member is required.
	StartIndex *int32

	// Value of the parsed secondary address component.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The phoneme details.
type PhonemeDetails struct {

	// How to pronounce the address.
	Address *AddressComponentPhonemes

	// List of PhonemeTranscription . See PhonemeTranscription for fields.
	Title []PhonemeTranscription

	noSmithyDocumentSerde
}

// How to pronounce the various components of the address or place.
type PhonemeTranscription struct {

	// A list of [BCP 47] compliant language codes for the results to be rendered in. If there
	// is no data for the result in the requested language, data will be returned in
	// the default language for the entry.
	//
	// [BCP 47]: https://en.wikipedia.org/wiki/IETF_language_tag
	Language *string

	// Boolean which indicates if it the preferred pronunciation.
	Preferred *bool

	// Value which indicates how to pronounce the value.
	Value *string

	noSmithyDocumentSerde
}

// Contains details about the postal code of the place or result.
type PostalCodeDetails struct {

	// The postal authority or entity. This could be a governmental authority, a
	// regulatory authority, or a designated postal operator.
	PostalAuthority PostalAuthority

	// An alphanumeric string included in a postal address to facilitate mail sorting,
	// such as post code, postcode, or ZIP code for which the result should possess.
	PostalCode *string

	// The postal code type.
	PostalCodeType PostalCodeType

	// The ZIP Classification Code, or in other words what type of postal code is it.
	UspsZip *UspsZip

	// The USPS ZIP+4 Record Type Code.
	UspsZipPlus4 *UspsZipPlus4

	noSmithyDocumentSerde
}

// Suggestions for refining individual query terms. Suggestions are returned as
// objects which note the term, suggested replacement, and its index in the query.
type QueryRefinement struct {

	// End index of the parsed query.
	//
	// This member is required.
	EndIndex *int32

	// The sub-string of the original query that is replaced by this query term.
	//
	// This member is required.
	OriginalTerm *string

	// The term that will be suggested to the user.
	//
	// This member is required.
	RefinedTerm *string

	// Start index of the parsed component.
	//
	// This member is required.
	StartIndex *int32

	noSmithyDocumentSerde
}

// The region or state results should be to be present in.
//
// Example: North Rhine-Westphalia .
type Region struct {

	// Abbreviated code for a the state, province or region of the country.
	//
	// Example: BC .
	Code *string

	// Name for a the state, province, or region of the country.
	//
	// Example: British Columbia .
	Name *string

	noSmithyDocumentSerde
}

// Indicates the starting and ending index of the region in the text query that
// match the found title.
type RegionHighlights struct {

	// Indicates the starting and ending index of the region in the text query that
	// match the found title.
	Code []Highlight

	// Indicates the starting and ending index of the region name in the text query
	// that match the found title.
	Name []Highlight

	noSmithyDocumentSerde
}

// Place that is related to the result item.
type RelatedPlace struct {

	// The PlaceId of the place result.
	//
	// This member is required.
	PlaceId *string

	// A PlaceType is a category that the result place must belong to.
	//
	// This member is required.
	PlaceType PlaceType

	// The localized display name of this result item based on request parameter
	// language .
	//
	// This member is required.
	Title *string

	// Position of the access point represented by longitude and latitude.
	AccessPoints []AccessPoint

	// The place address.
	Address *Address

	// The position, in longitude and latitude.
	Position []float64

	noSmithyDocumentSerde
}

// The included place types.
type ReverseGeocodeFilter struct {

	// The included place types.
	IncludePlaceTypes []ReverseGeocodeFilterPlaceType

	noSmithyDocumentSerde
}

// The returned location from the Reverse Geocode action.
type ReverseGeocodeResultItem struct {

	// The PlaceId of the place you wish to receive the information for.
	//
	// This member is required.
	PlaceId *string

	// A PlaceType is a category that the result place must belong to.
	//
	// This member is required.
	PlaceType PlaceType

	// The localized display name of this result item based on request parameter
	// language .
	//
	// This member is required.
	Title *string

	// Position of the access point represented by longitude and latitude.
	AccessPoints []AccessPoint

	// The place's address.
	Address *Address

	// Boolean indicating if the address provided has been corrected.
	AddressNumberCorrected *bool

	// Categories of results that results must belong to.
	Categories []Category

	// The distance in meters from the QueryPosition.
	Distance int64

	// List of food types offered by this result.
	FoodTypes []FoodType

	// All Intersections that are near the provided address.
	Intersections []Intersection

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	MapView []float64

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// The position in longitude and latitude.
	Position []float64

	// Contains details about the postal code of the place/result.
	PostalCodeDetails []PostalCodeDetails

	// The time zone in which the place is located.
	TimeZone *TimeZone

	noSmithyDocumentSerde
}

// SearchNearby structure which contains a set of inclusion/exclusion properties
// that results must possess in order to be returned as a result.
type SearchNearbyFilter struct {

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	BoundingBox []float64

	// The Business Chains associated with the place.
	ExcludeBusinessChains []string

	// Categories of results that results are excluded from.
	ExcludeCategories []string

	// Food types that results are excluded from.
	ExcludeFoodTypes []string

	// The Business Chains associated with the place.
	IncludeBusinessChains []string

	// Categories of results that results must belong too.
	IncludeCategories []string

	// A list of countries that all results must be in. Countries are represented by
	// either their alpha-2 or alpha-3 character codes.
	IncludeCountries []string

	// Food types that results are included from.
	IncludeFoodTypes []string

	noSmithyDocumentSerde
}

// The search results of nearby places.
type SearchNearbyResultItem struct {

	// The PlaceId of the place you wish to receive the information for.
	//
	// This member is required.
	PlaceId *string

	// A PlaceType is a category that the result place must belong to.
	//
	// This member is required.
	PlaceType PlaceType

	// The item's title.
	//
	// This member is required.
	Title *string

	// Position of the access point represent by longitude and latitude.
	AccessPoints []AccessPoint

	// Indicates known access restrictions on a vehicle access point. The index
	// correlates to an access point and indicates if access through this point has
	// some form of restriction.
	AccessRestrictions []AccessRestriction

	// The place's address.
	Address *Address

	// Boolean indicating if the address provided has been corrected.
	AddressNumberCorrected *bool

	// The Business Chains associated with the place.
	BusinessChains []BusinessChain

	// Categories of results that results must belong to.
	Categories []Category

	// List of potential contact methods for the result/place.
	Contacts *Contacts

	// The distance in meters from the QueryPosition.
	Distance int64

	// List of food types offered by this result.
	FoodTypes []FoodType

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	MapView []float64

	// List of opening hours objects.
	OpeningHours []OpeningHours

	// How the various components of the result's address are pronounced in various
	// languages.
	Phonemes *PhonemeDetails

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// The position in longitude and latitude.
	Position []float64

	// The time zone in which the place is located.
	TimeZone *TimeZone

	noSmithyDocumentSerde
}

// SearchText structure which contains a set of inclusion/exclusion properties
// that results must possess in order to be returned as a result.
type SearchTextFilter struct {

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	BoundingBox []float64

	// The Circle that all results must be in.
	Circle *FilterCircle

	//  A list of countries that all results must be in. Countries are represented by
	// either their alpha-2 or alpha-3 character codes.
	IncludeCountries []string

	noSmithyDocumentSerde
}

// The text search result.
type SearchTextResultItem struct {

	// The PlaceId of the place you wish to receive the information for.
	//
	// This member is required.
	PlaceId *string

	// A PlaceType is a category that the result place must belong to.
	//
	// This member is required.
	PlaceType PlaceType

	// The item's title.
	//
	// This member is required.
	Title *string

	// Position of the access point represent by longitude and latitude.
	AccessPoints []AccessPoint

	// Indicates known access restrictions on a vehicle access point. The index
	// correlates to an access point and indicates if access through this point has
	// some form of restriction.
	AccessRestrictions []AccessRestriction

	// The place's address.
	Address *Address

	// Boolean indicating if the address provided has been corrected.
	AddressNumberCorrected *bool

	// The Business Chains associated with the place.
	BusinessChains []BusinessChain

	// Categories of results that results must belong to.
	Categories []Category

	// List of potential contact methods for the result/place.
	Contacts *Contacts

	// The distance in meters from the QueryPosition.
	Distance int64

	// List of food types offered by this result.
	FoodTypes []FoodType

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	MapView []float64

	// List of opening hours objects.
	OpeningHours []OpeningHours

	// How the various components of the result's address are pronounced in various
	// languages.
	Phonemes *PhonemeDetails

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// The position, in longitude and latitude.
	Position []float64

	// The time zone in which the place is located.
	TimeZone *TimeZone

	noSmithyDocumentSerde
}

// Components that correspond to secondary identifiers on an address. The only
// component type supported currently is Unit.
type SecondaryAddressComponent struct {

	// Number that uniquely identifies a secondary address.
	//
	// This member is required.
	Number *string

	noSmithyDocumentSerde
}

// Match score for a secondary address component in the result.
type SecondaryAddressComponentMatchScore struct {

	// Match score for the secondary address number.
	Number float64

	noSmithyDocumentSerde
}

// Components of a street.
type StreetComponents struct {

	// Base name part of the street name.
	//
	// Example: Younge from the "Younge street".
	BaseName *string

	// Indicates the official directional identifiers assigned to highways.
	Direction *string

	// A [BCP 47] compliant language codes for the results to be rendered in. If there is no
	// data for the result in the requested language, data will be returned in the
	// default language for the entry.
	//
	// [BCP 47]: https://en.wikipedia.org/wiki/IETF_language_tag
	Language *string

	// A prefix is a directional identifier that precedes, but is not included in, the
	// base name of a road.
	//
	// Example: E for East.
	Prefix *string

	// A suffix is a directional identifier that follows, but is not included in, the
	// base name of a road.
	//
	// Example W for West.
	Suffix *string

	// Street type part of the street name.
	//
	// Example: "avenue" .
	Type *string

	// Defines if the street type is before or after the base name.
	TypePlacement TypePlacement

	// Defines a separator character such as "" or " " between the base name and type.
	TypeSeparator *string

	noSmithyDocumentSerde
}

// The sub-region.
type SubRegion struct {

	// Abbreviated code for the county or sub-region.
	Code *string

	// Name for the county or sub-region.
	Name *string

	noSmithyDocumentSerde
}

// Indicates the starting and ending index of the sub-region in the text query
// that match the found title.
type SubRegionHighlights struct {

	// Indicates the starting and ending index of the sub-region in the text query
	// that match the found title.
	Code []Highlight

	// Indicates the starting and ending index of the name in the text query that
	// match the found title.
	Name []Highlight

	noSmithyDocumentSerde
}

// Describes how the parts of the textQuery matched the input query by returning
// the sections of the response which matched to textQuery terms.
type SuggestAddressHighlights struct {

	// Indicates the starting and ending indexes of the places in the result which
	// were identified to match the textQuery. This result is useful for providing
	// emphasis to results where the user query directly matched to make selecting the
	// correct result from a list easier for an end user.
	Label []Highlight

	noSmithyDocumentSerde
}

// SuggestFilter structure which contains a set of inclusion/exclusion properties
// that results must possess in order to be returned as a result.
type SuggestFilter struct {

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	BoundingBox []float64

	// The Circle that all results must be in.
	Circle *FilterCircle

	//  A list of countries that all results must be in. Countries are represented by
	// either their alpha-2 or alpha-3 character codes.
	IncludeCountries []string

	noSmithyDocumentSerde
}

// Describes how the parts of the textQuery matched the input query by returning
// the sections of the response which matched to textQuery terms.
type SuggestHighlights struct {

	// The place's address.
	Address *SuggestAddressHighlights

	// Indicates the starting and ending index of the title in the text query that
	// match the found title.
	Title []Highlight

	noSmithyDocumentSerde
}

// The suggested place results.
type SuggestPlaceResult struct {

	// Position of the access point represent by longitude and latitude.
	AccessPoints []AccessPoint

	// Indicates known access restrictions on a vehicle access point. The index
	// correlates to an access point and indicates if access through this point has
	// some form of restriction.
	AccessRestrictions []AccessRestriction

	// The place's address.
	Address *Address

	// The Business Chains associated with the place.
	BusinessChains []BusinessChain

	// Categories of results that results must belong to.
	Categories []Category

	// The distance in meters from the QueryPosition.
	Distance int64

	// List of food types offered by this result.
	FoodTypes []FoodType

	// The bounding box enclosing the geometric shape (area or line) that an
	// individual result covers.
	//
	// The bounding box formed is defined as a set 4 coordinates: [{westward lng},
	// {southern lat}, {eastward lng}, {northern lat}]
	MapView []float64

	// How the various components of the result's address are pronounced in various
	// languages.
	Phonemes *PhonemeDetails

	// The PlaceId of the place you wish to receive the information for.
	PlaceId *string

	// A PlaceType is a category that the result place must belong to.
	PlaceType PlaceType

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// The position, in longitude and latitude.
	Position []float64

	// The time zone in which the place is located.
	TimeZone *TimeZone

	noSmithyDocumentSerde
}

// The suggested query results.
type SuggestQueryResult struct {

	// QueryId can be used to complete a follow up query through the SearchText API.
	// The QueryId retains context from the original Suggest request such as filters,
	// political view and language. See the SearchText API documentation for more
	// details [SearchText API docs].
	//
	// The fields QueryText , and QueryID are mutually exclusive.
	//
	// [SearchText API docs]: https://docs.aws.amazon.com/latest/APIReference/API_geoplaces_SearchText.html
	QueryId *string

	// The query type. Category queries will search for places which have an entry
	// matching the given category, for example "doctor office". BusinessChain queries
	// will search for instances of a given business.
	QueryType QueryType

	noSmithyDocumentSerde
}

// The resulting item from the suggested query.
type SuggestResultItem struct {

	// The result type. Place results represent the final result for a point of
	// interest, Query results represent a follow up query which can be completed
	// through the SearchText operation.
	//
	// This member is required.
	SuggestResultItemType SuggestResultItemType

	// The display title that should be used when presenting this option to the end
	// user.
	//
	// This member is required.
	Title *string

	// Describes how the parts of the response element matched the input query by
	// returning the sections of the response which matched to input query terms.
	Highlights *SuggestHighlights

	// The suggested place by its unique ID.
	Place *SuggestPlaceResult

	// The suggested query results.
	Query *SuggestQueryResult

	noSmithyDocumentSerde
}

// The time zone in which the place is located.
type TimeZone struct {

	// The time zone name.
	//
	// This member is required.
	Name *string

	// Time zone offset of the timezone from UTC.
	Offset *string

	// The offset of the time zone from UTC, in seconds.
	OffsetSeconds int64

	noSmithyDocumentSerde
}

// The USPS zip code.
type UspsZip struct {

	// The ZIP Classification Code, or in other words what type of postal code is it.
	ZipClassificationCode ZipClassificationCode

	noSmithyDocumentSerde
}

// The USPS zip+4 code.
type UspsZipPlus4 struct {

	// The USPS ZIP+4 Record Type Code.
	RecordTypeCode RecordTypeCode

	noSmithyDocumentSerde
}

// The input fails to satisfy the constraints specified by the Amazon Location
// service.
type ValidationExceptionField struct {

	// The error message.
	//
	// This member is required.
	Message *string

	// The name of the resource.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
