// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes an application resource that represents a collection of content for
// streaming with Amazon GameLift Streams. To retrieve additional application
// details, call [GetApplication].
//
// [GetApplication]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetApplication.html
type ApplicationSummary struct {

	// An Amazon Resource Name (ARN) that's assigned to an application resource and
	// uniquely identifies the application across all Amazon Web Services Regions.
	// Format is arn:aws:gameliftstreams:[AWS Region]:[AWS
	// account]:application/[resource ID] .
	//
	// This member is required.
	Arn *string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// A human-readable label for the application. You can edit this value.
	Description *string

	// An ID that uniquely identifies the application resource. Example ID: a-9ZY8X7Wv6
	// .
	Id *string

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	//  Configuration settings that identify the operating system for an application
	// resource. This can also include a compatibility layer and other drivers.
	//
	// A runtime environment can be one of the following:
	//
	//   - For Linux applications
	//
	//   - Ubuntu 22.04 LTS ( Type=UBUNTU, Version=22_04_LTS )
	//
	//   - For Windows applications
	//
	//   - Microsoft Windows Server 2022 Base ( Type=WINDOWS, Version=2022 )
	//
	//   - Proton 9.0-2 ( Type=PROTON, Version=20250516 )
	//
	//   - Proton 8.0-5 ( Type=PROTON, Version=20241007 )
	//
	//   - Proton 8.0-2c ( Type=PROTON, Version=20230704 )
	RuntimeEnvironment *RuntimeEnvironment

	// The current status of the application resource. Possible statuses include the
	// following:
	//
	//   - INITIALIZED : Amazon GameLift Streams has received the request and is
	//   initiating the work flow to create an application.
	//
	//   - PROCESSING : The create application work flow is in process. Amazon GameLift
	//   Streams is copying the content and caching for future deployment in a stream
	//   group.
	//
	//   - READY : The application is ready to deploy in a stream group.
	//
	//   - ERROR : An error occurred when setting up the application. For more
	//   information about the error, call GetApplication and refer to StatusReason .
	//
	//   - DELETING : Amazon GameLift Streams is in the process of deleting the
	//   application.
	Status ApplicationStatus

	noSmithyDocumentSerde
}

// Represents the default Amazon GameLift Streams application that a stream group
// hosts.
type DefaultApplication struct {

	// An [Amazon Resource Name (ARN)] that uniquely identifies the application resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	Arn *string

	// An ID that uniquely identifies the application resource. Example ID: a-9ZY8X7Wv6
	// .
	Id *string

	noSmithyDocumentSerde
}

// Provides details about the stream session's exported files.
type ExportFilesMetadata struct {

	//  The S3 bucket URI where Amazon GameLift Streams uploaded the set of compressed
	// exported files for a stream session. Amazon GameLift Streams generates a ZIP
	// file name based on the stream session metadata. Alternatively, you can provide a
	// custom file name with a .zip file extension.
	//
	// Example 1: If you provide an S3 URI called
	// s3://amzn-s3-demo-destination-bucket/MyGame_Session1.zip , then Amazon GameLift
	// Streams will save the files at that location.
	//
	// Example 2: If you provide an S3 URI called
	// s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/ , then Amazon
	// GameLift Streams will save the files at
	// s3://amzn-s3-demo-destination-bucket/MyGameSessions_ExportedFiles/YYYYMMDD-HHMMSS-appId-sg-Id-sessionId.zip
	// or another similar name.
	OutputUri *string

	// The result of the [ExportStreamSessionFiles] operation.
	//
	// [ExportStreamSessionFiles]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ExportStreamSessionFiles.html
	Status ExportFilesStatus

	// A short description of the reason the export is in FAILED status.
	StatusReason *string

	noSmithyDocumentSerde
}

// Configuration settings that define a stream group's stream capacity for a
// location. When configuring a location for the first time, you must specify a
// numeric value for at least one of the two capacity types. To update the capacity
// for an existing stream group, call [UpdateStreamGroup]. To add a new location and specify its
// capacity, call [AddStreamGroupLocations].
//
// [UpdateStreamGroup]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html
// [AddStreamGroupLocations]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_AddStreamGroupLocations.html
type LocationConfiguration struct {

	//  A location's name. For example, us-east-1 . For a complete list of locations
	// that Amazon GameLift Streams supports, refer to [Regions, quotas, and limitations]in the Amazon GameLift Streams
	// Developer Guide.
	//
	// [Regions, quotas, and limitations]: https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html
	//
	// This member is required.
	LocationName *string

	// The streaming capacity that is allocated and ready to handle stream requests
	// without delay. You pay for this capacity whether it's in use or not. Best for
	// quickest time from streaming request to streaming session. Default is 1 (2 for
	// high stream classes) when creating a stream group or adding a location.
	AlwaysOnCapacity *int32

	// The streaming capacity that Amazon GameLift Streams can allocate in response to
	// stream requests, and then de-allocate when the session has terminated. This
	// offers a cost control measure at the expense of a greater startup time
	// (typically under 5 minutes). Default is 0 when creating a stream group or adding
	// a location.
	OnDemandCapacity *int32

	noSmithyDocumentSerde
}

// Represents a location and its corresponding stream capacity and status.
type LocationState struct {

	// This value is the stream capacity that Amazon GameLift Streams has provisioned
	// in a stream group that can respond immediately to stream requests. It includes
	// resources that are currently streaming and resources that are idle and ready to
	// respond to stream requests. You pay for this capacity whether it's in use or
	// not. After making changes to capacity, it can take a few minutes for the
	// allocated capacity count to reflect the change while compute resources are
	// allocated or deallocated. Similarly, when allocated on-demand capacity is no
	// longer needed, it can take a few minutes for Amazon GameLift Streams to spin
	// down the allocated capacity.
	AllocatedCapacity *int32

	// The streaming capacity that is allocated and ready to handle stream requests
	// without delay. You pay for this capacity whether it's in use or not. Best for
	// quickest time from streaming request to streaming session. Default is 1 (2 for
	// high stream classes) when creating a stream group or adding a location.
	AlwaysOnCapacity *int32

	// This value is the amount of allocated capacity that is not currently streaming.
	// It represents the stream group's ability to respond immediately to new stream
	// requests with near-instant startup time.
	IdleCapacity *int32

	//  A location's name. For example, us-east-1 . For a complete list of locations
	// that Amazon GameLift Streams supports, refer to [Regions, quotas, and limitations]in the Amazon GameLift Streams
	// Developer Guide.
	//
	// [Regions, quotas, and limitations]: https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html
	LocationName *string

	// The streaming capacity that Amazon GameLift Streams can allocate in response to
	// stream requests, and then de-allocate when the session has terminated. This
	// offers a cost control measure at the expense of a greater startup time
	// (typically under 5 minutes). Default is 0 when creating a stream group or adding
	// a location.
	OnDemandCapacity *int32

	// This value is the always-on capacity that you most recently requested for a
	// stream group. You request capacity separately for each location in a stream
	// group. In response to an increase in requested capacity, Amazon GameLift Streams
	// attempts to provision compute resources to make the stream group's allocated
	// capacity meet requested capacity. When always-on capacity is decreased, it can
	// take a few minutes to deprovision allocated capacity to match the requested
	// capacity.
	RequestedCapacity *int32

	// This value is set of locations, including their name, current status, and
	// capacities.
	//
	// A location can be in one of the following states:
	//
	//   - ACTIVATING : Amazon GameLift Streams is preparing the location. You cannot
	//   stream from, scale the capacity of, or remove this location yet.
	//
	//   - ACTIVE : The location is provisioned with initial capacity. You can now
	//   stream from, scale the capacity of, or remove this location.
	//
	//   - ERROR : Amazon GameLift Streams failed to set up this location. The
	//   StatusReason field describes the error. You can remove this location and try
	//   to add it again.
	//
	//   - REMOVING : Amazon GameLift Streams is working to remove this location. This
	//   will release all provisioned capacity for this location in this stream group.
	Status StreamGroupLocationStatus

	noSmithyDocumentSerde
}

// Represents the status of the replication of an application to a location. An
// application cannot be streamed from a location until it has finished replicating
// there.
type ReplicationStatus struct {

	//  A location's name. For example, us-east-1 . For a complete list of locations
	// that Amazon GameLift Streams supports, refer to [Regions, quotas, and limitations]in the Amazon GameLift Streams
	// Developer Guide.
	//
	// [Regions, quotas, and limitations]: https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html
	Location *string

	// The current status of the replication process.
	Status ReplicationStatusType

	noSmithyDocumentSerde
}

// Configuration settings that identify the operating system for an application
// resource. This can also include a compatibility layer and other drivers.
//
// A runtime environment can be one of the following:
//
//   - For Linux applications
//
//   - Ubuntu 22.04 LTS ( Type=UBUNTU, Version=22_04_LTS )
//
//   - For Windows applications
//
//   - Microsoft Windows Server 2022 Base ( Type=WINDOWS, Version=2022 )
//
//   - Proton 9.0-2 ( Type=PROTON, Version=20250516 )
//
//   - Proton 8.0-5 ( Type=PROTON, Version=20241007 )
//
//   - Proton 8.0-2c ( Type=PROTON, Version=20230704 )
type RuntimeEnvironment struct {

	// The operating system and other drivers. For Proton, this also includes the
	// Proton compatibility layer.
	//
	// This member is required.
	Type RuntimeEnvironmentType

	// Versioned container environment for the application operating system.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Describes a Amazon GameLift Streams stream group resource for hosting content
// streams. To retrieve additional stream group details, call [GetStreamGroup].
//
// [GetStreamGroup]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamGroup.html
type StreamGroupSummary struct {

	// An [Amazon Resource Name (ARN)] that uniquely identifies the stream group resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Arn *string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// Object that identifies the Amazon GameLift Streams application to stream with
	// this stream group.
	DefaultApplication *DefaultApplication

	// A descriptive label for the stream group.
	Description *string

	// The time at which this stream group expires. Timestamps are expressed using in
	// ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC). After this time, you
	// will no longer be able to update this stream group or use it to start stream
	// sessions. Only Get and Delete operations will work on an expired stream group.
	ExpiresAt *time.Time

	// An ID that uniquely identifies the stream group resource. Example ID:
	// sg-1AB2C3De4 .
	Id *string

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// The current status of the stream group resource. Possible statuses include the
	// following:
	//
	//   - ACTIVATING : The stream group is deploying and isn't ready to host streams.
	//
	//   - ACTIVE : The stream group is ready to host streams.
	//
	//   - ACTIVE_WITH_ERRORS : One or more locations in the stream group are in an
	//   error state. Verify the details of individual locations and remove any locations
	//   which are in error.
	//
	//   - DELETING : Amazon GameLift Streams is in the process of deleting the stream
	//   group.
	//
	//   - ERROR : An error occurred when the stream group deployed. See StatusReason
	//   (returned by CreateStreamGroup , GetStreamGroup , and UpdateStreamGroup ) for
	//   more information.
	//
	//   - EXPIRED : The stream group is expired and can no longer host streams. This
	//   typically occurs when a stream group is 365 days old, as indicated by the value
	//   of ExpiresAt . Create a new stream group to resume streaming capabilities.
	//
	//   - UPDATING_LOCATIONS : One or more locations in the stream group are in the
	//   process of updating (either activating or deleting).
	Status StreamGroupStatus

	// The target stream quality for the stream group.
	//
	// A stream class can be one of the following:
	//
	//   - gen5n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen5n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen5n_ultra (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen4n_ultra (NVIDIA, ultra) Supports applications with high 3D scene
	//   complexity. Uses dedicated NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	StreamClass StreamClass

	noSmithyDocumentSerde
}

// Describes an Amazon GameLift Streams stream session. To retrieve additional
// details for the stream session, call [GetStreamSession].
//
// [GetStreamSession]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html
type StreamSessionSummary struct {

	// An [Amazon Resource Name (ARN)] that uniquely identifies the application resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	ApplicationArn *string

	// An [Amazon Resource Name (ARN)] that uniquely identifies the stream session resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamsession/sg-1AB2C3De4/ABC123def4567
	// .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	Arn *string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// Provides details about the stream session's exported files.
	ExportFilesMetadata *ExportFilesMetadata

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// The location where Amazon GameLift Streams hosts and streams your application.
	// For example, us-east-1 . For a complete list of locations that Amazon GameLift
	// Streams supports, refer to [Regions, quotas, and limitations]in the Amazon GameLift Streams Developer Guide.
	//
	// [Regions, quotas, and limitations]: https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/regions-quotas.html
	Location *string

	// The data transfer protocol in use with the stream session.
	Protocol Protocol

	// The current status of the stream session resource.
	//
	//   - ACTIVATING : The stream session is starting and preparing to stream.
	//
	//   - ACTIVE : The stream session is ready and waiting for a client connection. A
	//   client has ConnectionTimeoutSeconds (specified in StartStreamSession ) from
	//   when the session reaches ACTIVE state to establish a connection. If no client
	//   connects within this timeframe, the session automatically terminates.
	//
	//   - CONNECTED : The stream session has a connected client. A session will
	//   automatically terminate if there is no user input for 60 minutes, or if the
	//   maximum length of a session specified by SessionLengthSeconds in
	//   StartStreamSession is exceeded.
	//
	//   - ERROR : The stream session failed to activate. See StatusReason (returned by
	//   GetStreamSession and StartStreamSession ) for more information.
	//
	//   - PENDING_CLIENT_RECONNECTION : A client has recently disconnected and the
	//   stream session is waiting for the client to reconnect. A client has
	//   ConnectionTimeoutSeconds (specified in StartStreamSession ) from when the
	//   session reaches PENDING_CLIENT_RECONNECTION state to re-establish a
	//   connection. If no client connects within this timeframe, the session
	//   automatically terminates.
	//
	//   - RECONNECTING : A client has initiated a reconnect to a session that was in
	//   PENDING_CLIENT_RECONNECTION state.
	//
	//   - TERMINATING : The stream session is ending.
	//
	//   - TERMINATED : The stream session has ended.
	Status StreamSessionStatus

	//  An opaque, unique identifier for an end-user, defined by the developer.
	UserId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
