// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Updates the mutable configuration settings for a Amazon GameLift Streams
//
// application resource. You can change the Description , ApplicationLogOutputUri ,
// and ApplicationLogPaths .
//
// To update application settings, specify the application ID and provide the new
// values. If the operation is successful, it returns the complete updated set of
// settings for the application.
func (c *Client) UpdateApplication(ctx context.Context, params *UpdateApplicationInput, optFns ...func(*Options)) (*UpdateApplicationOutput, error) {
	if params == nil {
		params = &UpdateApplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateApplication", params, optFns, c.addOperationUpdateApplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateApplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateApplicationInput struct {

	// An [Amazon Resource Name (ARN)] or ID that uniquely identifies the application resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 . Example
	// ID: a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	// An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to
	// save application logs. Required if you specify one or more ApplicationLogPaths .
	//
	// The log bucket must have permissions that give Amazon GameLift Streams access
	// to write the log files. For more information, see [Application log bucket permission policy]in the Amazon GameLift
	// Streams Developer Guide.
	//
	// [Application log bucket permission policy]: https://docs.aws.amazon.com/gameliftstreams/latest/developerguide/applications.html#application-bucket-permission-template
	ApplicationLogOutputUri *string

	// Locations of log files that your content generates during a stream session.
	// Enter path values that are relative to the ApplicationSourceUri location. You
	// can specify up to 10 log paths. Amazon GameLift Streams uploads designated log
	// files to the Amazon S3 bucket that you specify in ApplicationLogOutputUri at
	// the end of a stream session. To retrieve stored log files, call [GetStreamSession]and get the
	// LogFileLocationUri .
	//
	// [GetStreamSession]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html
	ApplicationLogPaths []string

	// A human-readable label for the application.
	Description *string

	noSmithyDocumentSerde
}

type UpdateApplicationOutput struct {

	// The [Amazon Resource Name (ARN)] that's assigned to an application resource and uniquely identifies it
	// across all Amazon Web Services Regions. Format is arn:aws:gameliftstreams:[AWS
	// Region]:[AWS account]:application/[resource ID] .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Arn *string

	// An Amazon S3 URI to a bucket where you would like Amazon GameLift Streams to
	// save application logs. Required if you specify one or more ApplicationLogPaths .
	ApplicationLogOutputUri *string

	// Locations of log files that your content generates during a stream session.
	// Amazon GameLift Streams uploads log files to the Amazon S3 bucket that you
	// specify in ApplicationLogOutputUri at the end of a stream session. To retrieve
	// stored log files, call [GetStreamSession]and get the LogFileLocationUri .
	//
	// [GetStreamSession]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html
	ApplicationLogPaths []string

	// The original Amazon S3 location of uploaded stream content for the application.
	ApplicationSourceUri *string

	//  A set of stream groups that this application is associated with. You can use
	// any of these stream groups to stream your application.
	//
	// This value is a set of [Amazon Resource Names (ARNs)] that uniquely identify stream group resources. Example
	// ARN: arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	AssociatedStreamGroups []string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// A human-readable label for the application. You can edit this value.
	Description *string

	// The relative path and file name of the executable file that launches the
	// content for streaming.
	ExecutablePath *string

	// A unique ID value that is assigned to the resource when it's created. Format
	// example: a-9ZY8X7Wv6 .
	Id *string

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// A set of replication statuses for each location.
	ReplicationStatuses []types.ReplicationStatus

	//  Configuration settings that identify the operating system for an application
	// resource. This can also include a compatibility layer and other drivers.
	//
	// A runtime environment can be one of the following:
	//
	//   - For Linux applications
	//
	//   - Ubuntu 22.04 LTS ( Type=UBUNTU, Version=22_04_LTS )
	//
	//   - For Windows applications
	//
	//   - Microsoft Windows Server 2022 Base ( Type=WINDOWS, Version=2022 )
	//
	//   - Proton 9.0-2 ( Type=PROTON, Version=20250516 )
	//
	//   - Proton 8.0-5 ( Type=PROTON, Version=20241007 )
	//
	//   - Proton 8.0-2c ( Type=PROTON, Version=20230704 )
	RuntimeEnvironment *types.RuntimeEnvironment

	// The current status of the application resource. Possible statuses include the
	// following:
	//
	//   - INITIALIZED : Amazon GameLift Streams has received the request and is
	//   initiating the work flow to create an application.
	//
	//   - PROCESSING : The create application work flow is in process. Amazon GameLift
	//   Streams is copying the content and caching for future deployment in a stream
	//   group.
	//
	//   - READY : The application is ready to deploy in a stream group.
	//
	//   - ERROR : An error occurred when setting up the application. See StatusReason
	//   for more information.
	//
	//   - DELETING : Amazon GameLift Streams is in the process of deleting the
	//   application.
	Status types.ApplicationStatus

	// A short description of the status reason when the application is in ERROR
	// status.
	StatusReason types.ApplicationStatusReason

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateApplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateApplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateApplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateApplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateApplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateApplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateApplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateApplication",
	}
}
