// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This API works with the following fleet types: Container
//
// Retrieves a collection of container fleet resources in an Amazon Web Services
// Region. For fleets that have multiple locations, this operation retrieves fleets
// based on their home Region only.
//
// Request options
//
//   - Get a list of all fleets. Call this operation without specifying a
//     container group definition.
//
//   - Get a list of fleets filtered by container group definition. Provide the
//     container group definition name or ARN value.
//
//   - To get a list of all Amazon GameLift Servers Realtime fleets with a
//     specific configuration script, provide the script ID.
//
// Use the pagination parameters to retrieve results as a set of sequential pages.
//
// If successful, this operation returns a collection of container fleets that
// match the request parameters. A NextToken value is also returned if there are
// more result pages to retrieve.
//
// Fleet IDs are returned in no particular order.
func (c *Client) ListContainerFleets(ctx context.Context, params *ListContainerFleetsInput, optFns ...func(*Options)) (*ListContainerFleetsOutput, error) {
	if params == nil {
		params = &ListContainerFleetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListContainerFleets", params, optFns, c.addOperationListContainerFleetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListContainerFleetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListContainerFleetsInput struct {

	// The container group definition to filter the list on. Use this parameter to
	// retrieve only those fleets that use the specified container group definition.
	// You can specify the container group definition's name to get fleets with the
	// latest versions. Alternatively, provide an ARN value to get fleets with a
	// specific version number.
	ContainerGroupDefinitionName *string

	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int32

	// A token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this operation. To start at
	// the beginning of the result set, do not specify a value.
	NextToken *string

	noSmithyDocumentSerde
}

type ListContainerFleetsOutput struct {

	// A collection of container fleet objects for all fleets that match the request
	// criteria.
	ContainerFleets []types.ContainerFleet

	// A token that indicates where to resume retrieving results on the next call to
	// this operation. If no token is returned, these results represent the end of the
	// list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListContainerFleetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListContainerFleets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListContainerFleets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListContainerFleets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListContainerFleets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListContainerFleetsPaginatorOptions is the paginator options for
// ListContainerFleets
type ListContainerFleetsPaginatorOptions struct {
	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListContainerFleetsPaginator is a paginator for ListContainerFleets
type ListContainerFleetsPaginator struct {
	options   ListContainerFleetsPaginatorOptions
	client    ListContainerFleetsAPIClient
	params    *ListContainerFleetsInput
	nextToken *string
	firstPage bool
}

// NewListContainerFleetsPaginator returns a new ListContainerFleetsPaginator
func NewListContainerFleetsPaginator(client ListContainerFleetsAPIClient, params *ListContainerFleetsInput, optFns ...func(*ListContainerFleetsPaginatorOptions)) *ListContainerFleetsPaginator {
	if params == nil {
		params = &ListContainerFleetsInput{}
	}

	options := ListContainerFleetsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListContainerFleetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListContainerFleetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListContainerFleets page.
func (p *ListContainerFleetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListContainerFleetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListContainerFleets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListContainerFleetsAPIClient is a client that implements the
// ListContainerFleets operation.
type ListContainerFleetsAPIClient interface {
	ListContainerFleets(context.Context, *ListContainerFleetsInput, ...func(*Options)) (*ListContainerFleetsOutput, error)
}

var _ ListContainerFleetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListContainerFleets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListContainerFleets",
	}
}
