// Code generated by smithy-go-codegen DO NOT EDIT.

package evs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/evs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon EVS environment that runs VCF software, such as SDDC Manager,
// NSX Manager, and vCenter Server.
//
// During environment creation, Amazon EVS performs validations on DNS settings,
// provisions VLAN subnets and hosts, and deploys the supplied version of VCF.
//
// It can take several hours to create an environment. After the deployment
// completes, you can configure VCF in the vSphere user interface according to your
// needs.
//
// You cannot use the dedicatedHostId and placementGroupId parameters together in
// the same CreateEnvironment action. This results in a ValidationException
// response.
func (c *Client) CreateEnvironment(ctx context.Context, params *CreateEnvironmentInput, optFns ...func(*Options)) (*CreateEnvironmentOutput, error) {
	if params == nil {
		params = &CreateEnvironmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEnvironment", params, optFns, c.addOperationCreateEnvironmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEnvironmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEnvironmentInput struct {

	//  The connectivity configuration for the environment. Amazon EVS requires that
	// you specify two route server peer IDs. During environment creation, the route
	// server endpoints peer with the NSX edges over the NSX uplink subnet, providing
	// BGP-based dynamic routing for overlay networks.
	//
	// This member is required.
	ConnectivityInfo *types.ConnectivityInfo

	// The ESXi hosts to add to the environment. Amazon EVS requires that you provide
	// details for a minimum of 4 hosts during environment creation.
	//
	// For each host, you must provide the desired hostname, EC2 SSH keypair name, and
	// EC2 instance type. Optionally, you can also provide a partition or cluster
	// placement group to use, or use Amazon EC2 Dedicated Hosts.
	//
	// This member is required.
	Hosts []types.HostInfoForCreate

	// The initial VLAN subnets for the Amazon EVS environment.
	//
	// For each Amazon EVS VLAN subnet, you must specify a non-overlapping CIDR block.
	// Amazon EVS VLAN subnets have a minimum CIDR block size of /28 and a maximum size
	// of /24.
	//
	// This member is required.
	InitialVlans *types.InitialVlans

	// The license information that Amazon EVS requires to create an environment.
	// Amazon EVS requires two license keys: a VCF solution key and a vSAN license key.
	// The VCF solution key must cover a minimum of 256 cores. The vSAN license key
	// must provide at least 110 TiB of vSAN capacity.
	//
	// VCF licenses can be used for only one Amazon EVS environment. Amazon EVS does
	// not support reuse of VCF licenses for multiple environments.
	//
	// VCF license information can be retrieved from the Broadcom portal.
	//
	// This member is required.
	LicenseInfo []types.LicenseInfo

	// The subnet that is used to establish connectivity between the Amazon EVS
	// control plane and VPC. Amazon EVS uses this subnet to validate mandatory DNS
	// records for your VCF appliances and hosts and create the environment.
	//
	// This member is required.
	ServiceAccessSubnetId *string

	// The Broadcom Site ID that is allocated to you as part of your electronic
	// software delivery. This ID allows customer access to the Broadcom portal, and is
	// provided to you by Broadcom at the close of your software contract or contract
	// renewal. Amazon EVS uses the Broadcom Site ID that you provide to meet Broadcom
	// VCF license usage reporting requirements for Amazon EVS.
	//
	// This member is required.
	SiteId *string

	// Customer confirmation that the customer has purchased and will continue to
	// maintain the required number of VCF software licenses to cover all physical
	// processor cores in the Amazon EVS environment. Information about your VCF
	// software in Amazon EVS will be shared with Broadcom to verify license
	// compliance. Amazon EVS does not validate license keys. To validate license keys,
	// visit the Broadcom support portal.
	//
	// This member is required.
	TermsAccepted *bool

	// The DNS hostnames for the virtual machines that host the VCF management
	// appliances. Amazon EVS requires that you provide DNS hostnames for the following
	// appliances: vCenter, NSX Manager, SDDC Manager, and Cloud Builder.
	//
	// This member is required.
	VcfHostnames *types.VcfHostnames

	//  The VCF version to use for the environment. Amazon EVS only supports VCF
	// version 5.2.1 at this time.
	//
	// This member is required.
	VcfVersion types.VcfVersion

	// A unique ID for the VPC that the environment is deployed inside.
	//
	// Amazon EVS requires that all VPC subnets exist in a single Availability Zone in
	// a Region where the service is available.
	//
	// The VPC that you specify must have a valid DHCP option set with domain name, at
	// least two DNS servers, and an NTP server. These settings are used to configure
	// your VCF appliances and hosts. The VPC cannot be used with any other deployed
	// Amazon EVS environment. Amazon EVS does not provide multi-VPC support for
	// environments at this time.
	//
	// Amazon EVS does not support the following Amazon Web Services networking
	// options for NSX overlay connectivity: cross-Region VPC peering, Amazon S3
	// gateway endpoints, or Amazon Web Services Direct Connect virtual private gateway
	// associations.
	//
	// Ensure that you specify a VPC that is adequately sized to accommodate the
	// {evws} subnets.
	//
	// This member is required.
	VpcId *string

	// This parameter is not used in Amazon EVS currently. If you supply input for
	// this parameter, it will have no effect.
	//
	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the environment creation request. If you do not specify a client token, a
	// randomly generated token is used for the request to ensure idempotency.
	ClientToken *string

	// The name to give to your environment. The name can contain only alphanumeric
	// characters (case-sensitive), hyphens, and underscores. It must start with an
	// alphanumeric character, and can't be longer than 100 characters. The name must
	// be unique within the Amazon Web Services Region and Amazon Web Services account
	// that you're creating the environment in.
	EnvironmentName *string

	// A unique ID for the customer-managed KMS key that is used to encrypt the VCF
	// credential pairs for SDDC Manager, NSX Manager, and vCenter appliances. These
	// credentials are stored in Amazon Web Services Secrets Manager.
	KmsKeyId *string

	// The security group that controls communication between the Amazon EVS control
	// plane and VPC. The default security group is used if a custom security group
	// isn't specified.
	//
	// The security group should allow access to the following.
	//
	//   - TCP/UDP access to the DNS servers
	//
	//   - HTTPS/SSH access to the host management VLAN subnet
	//
	//   - HTTPS/SSH access to the Management VM VLAN subnet
	//
	// You should avoid modifying the security group rules after deployment, as this
	// can break the persistent connection between the Amazon EVS control plane and
	// VPC. This can cause future environment actions like adding or removing hosts to
	// fail.
	ServiceAccessSecurityGroups *types.ServiceAccessSecurityGroups

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateEnvironmentOutput struct {

	// A description of the created environment.
	Environment *types.Environment

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEnvironmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateEnvironment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateEnvironment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEnvironment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateEnvironmentMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEnvironmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEnvironment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateEnvironment struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateEnvironment) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateEnvironmentInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateEnvironmentMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateEnvironment{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateEnvironment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEnvironment",
	}
}
