// Code generated by smithy-go-codegen DO NOT EDIT.

package emrcontainers

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/emrcontainers/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists security configurations based on a set of parameters. Security
// configurations in Amazon EMR on EKS are templates for different security setups.
// You can use security configurations to configure the Lake Formation integration
// setup. You can also create a security configuration to re-use a security setup
// each time you create a virtual cluster.
func (c *Client) ListSecurityConfigurations(ctx context.Context, params *ListSecurityConfigurationsInput, optFns ...func(*Options)) (*ListSecurityConfigurationsOutput, error) {
	if params == nil {
		params = &ListSecurityConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSecurityConfigurations", params, optFns, c.addOperationListSecurityConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSecurityConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSecurityConfigurationsInput struct {

	// The date and time after which the security configuration was created.
	CreatedAfter *time.Time

	// The date and time before which the security configuration was created.
	CreatedBefore *time.Time

	// The maximum number of security configurations the operation can list.
	MaxResults *int32

	// The token for the next set of security configurations to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSecurityConfigurationsOutput struct {

	// The token for the next set of security configurations to return.
	NextToken *string

	// The list of returned security configurations.
	SecurityConfigurations []types.SecurityConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSecurityConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSecurityConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSecurityConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSecurityConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSecurityConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSecurityConfigurationsPaginatorOptions is the paginator options for
// ListSecurityConfigurations
type ListSecurityConfigurationsPaginatorOptions struct {
	// The maximum number of security configurations the operation can list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSecurityConfigurationsPaginator is a paginator for
// ListSecurityConfigurations
type ListSecurityConfigurationsPaginator struct {
	options   ListSecurityConfigurationsPaginatorOptions
	client    ListSecurityConfigurationsAPIClient
	params    *ListSecurityConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListSecurityConfigurationsPaginator returns a new
// ListSecurityConfigurationsPaginator
func NewListSecurityConfigurationsPaginator(client ListSecurityConfigurationsAPIClient, params *ListSecurityConfigurationsInput, optFns ...func(*ListSecurityConfigurationsPaginatorOptions)) *ListSecurityConfigurationsPaginator {
	if params == nil {
		params = &ListSecurityConfigurationsInput{}
	}

	options := ListSecurityConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSecurityConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSecurityConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSecurityConfigurations page.
func (p *ListSecurityConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSecurityConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSecurityConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSecurityConfigurationsAPIClient is a client that implements the
// ListSecurityConfigurations operation.
type ListSecurityConfigurationsAPIClient interface {
	ListSecurityConfigurations(context.Context, *ListSecurityConfigurationsInput, ...func(*Options)) (*ListSecurityConfigurationsOutput, error)
}

var _ ListSecurityConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSecurityConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSecurityConfigurations",
	}
}
