// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The customer has exceeded the allowed rate of API calls.
type APICallRateForCustomerExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *APICallRateForCustomerExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *APICallRateForCustomerExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *APICallRateForCustomerExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "APICallRateForCustomerExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *APICallRateForCustomerExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified Amazon EC2 security group is already authorized for the specified
// cache security group.
type AuthorizationAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon EC2 security group is not authorized for the specified
// cache security group.
type AuthorizationNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You already have a cluster with the given identifier.
type CacheClusterAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheClusterAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheClusterAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheClusterAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheClusterAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheClusterAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested cluster ID does not refer to an existing cluster.
type CacheClusterNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheClusterNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheClusterNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheClusterNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheClusterNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheClusterNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A cache parameter group with the requested name already exists.
type CacheParameterGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheParameterGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheParameterGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheParameterGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheParameterGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheParameterGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested cache parameter group name does not refer to an existing cache
// parameter group.
type CacheParameterGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheParameterGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheParameterGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheParameterGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheParameterGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheParameterGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the maximum number of
// cache security groups.
type CacheParameterGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheParameterGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheParameterGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheParameterGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheParameterGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheParameterGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A cache security group with the specified name already exists.
type CacheSecurityGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSecurityGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSecurityGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSecurityGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheSecurityGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSecurityGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested cache security group name does not refer to an existing cache
// security group.
type CacheSecurityGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSecurityGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSecurityGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSecurityGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheSecurityGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSecurityGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the allowed number of
// cache security groups.
type CacheSecurityGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSecurityGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSecurityGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSecurityGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "QuotaExceeded.CacheSecurityGroup"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSecurityGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested cache subnet group name is already in use by an existing cache
// subnet group.
type CacheSubnetGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSubnetGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSubnetGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSubnetGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheSubnetGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSubnetGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested cache subnet group is currently in use.
type CacheSubnetGroupInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSubnetGroupInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSubnetGroupInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSubnetGroupInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheSubnetGroupInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSubnetGroupInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested cache subnet group name does not refer to an existing cache
// subnet group.
type CacheSubnetGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSubnetGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSubnetGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSubnetGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheSubnetGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSubnetGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the allowed number of
// cache subnet groups.
type CacheSubnetGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSubnetGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSubnetGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSubnetGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheSubnetGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSubnetGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request cannot be processed because it would exceed the allowed number of
// subnets in a cache subnet group.
type CacheSubnetQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CacheSubnetQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CacheSubnetQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CacheSubnetQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CacheSubnetQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CacheSubnetQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the allowed number of
// clusters per customer.
type ClusterQuotaForCustomerExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ClusterQuotaForCustomerExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ClusterQuotaForCustomerExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ClusterQuotaForCustomerExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ClusterQuotaForCustomerExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ClusterQuotaForCustomerExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The default user assigned to the user group.
type DefaultUserAssociatedToUserGroupFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DefaultUserAssociatedToUserGroupFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DefaultUserAssociatedToUserGroupFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DefaultUserAssociatedToUserGroupFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DefaultUserAssociatedToUserGroup"
	}
	return *e.ErrorCodeOverride
}
func (e *DefaultUserAssociatedToUserGroupFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You must add default user to a user group.
type DefaultUserRequired struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DefaultUserRequired) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DefaultUserRequired) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DefaultUserRequired) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DefaultUserRequired"
	}
	return *e.ErrorCodeOverride
}
func (e *DefaultUserRequired) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A user with this username already exists.
type DuplicateUserNameFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateUserNameFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateUserNameFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateUserNameFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateUserName"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateUserNameFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Global datastore name already exists.
type GlobalReplicationGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GlobalReplicationGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GlobalReplicationGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GlobalReplicationGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GlobalReplicationGroupAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *GlobalReplicationGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The Global datastore does not exist
type GlobalReplicationGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GlobalReplicationGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GlobalReplicationGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GlobalReplicationGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GlobalReplicationGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *GlobalReplicationGroupNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested cache node type is not available in the specified Availability
// Zone. For more information, see [InsufficientCacheClusterCapacity]in the ElastiCache User Guide.
//
// [InsufficientCacheClusterCapacity]: http://docs.aws.amazon.com/AmazonElastiCache/latest/dg/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY
type InsufficientCacheClusterCapacityFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientCacheClusterCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientCacheClusterCapacityFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientCacheClusterCapacityFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientCacheClusterCapacity"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientCacheClusterCapacityFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested Amazon Resource Name (ARN) does not refer to an existing resource.
type InvalidARNFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidARNFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidARNFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidARNFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidARN"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidARNFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested cluster is not in the available state.
type InvalidCacheClusterStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCacheClusterStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCacheClusterStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCacheClusterStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCacheClusterState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCacheClusterStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The current state of the cache parameter group does not allow the requested
// operation to occur.
type InvalidCacheParameterGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCacheParameterGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCacheParameterGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCacheParameterGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCacheParameterGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCacheParameterGroupStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The current state of the cache security group does not allow deletion.
type InvalidCacheSecurityGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCacheSecurityGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCacheSecurityGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCacheSecurityGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCacheSecurityGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCacheSecurityGroupStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You must enter valid credentials.
type InvalidCredentialsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCredentialsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCredentialsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCredentialsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCredentialsException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCredentialsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Global datastore is not available or in primary-only state.
type InvalidGlobalReplicationGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidGlobalReplicationGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGlobalReplicationGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGlobalReplicationGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidGlobalReplicationGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidGlobalReplicationGroupStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The KMS key supplied is not valid.
type InvalidKMSKeyFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidKMSKeyFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidKMSKeyFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidKMSKeyFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidKMSKeyFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidKMSKeyFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Two or more incompatible parameters were specified.
type InvalidParameterCombinationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterCombinationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterCombinationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterCombination"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterCombinationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The value for a parameter is invalid.
type InvalidParameterValueException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterValueException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterValueException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidParameterValue"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidParameterValueException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested replication group is not in the available state.
type InvalidReplicationGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidReplicationGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidReplicationGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidReplicationGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidReplicationGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidReplicationGroupStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The state of the serverless cache snapshot was not received. Available for
// Valkey, Redis OSS and Serverless Memcached only.
type InvalidServerlessCacheSnapshotStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidServerlessCacheSnapshotStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidServerlessCacheSnapshotStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidServerlessCacheSnapshotStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidServerlessCacheSnapshotStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidServerlessCacheSnapshotStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The account for these credentials is not currently active.
type InvalidServerlessCacheStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidServerlessCacheStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidServerlessCacheStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidServerlessCacheStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidServerlessCacheStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidServerlessCacheStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The current state of the snapshot does not allow the requested operation to
// occur.
type InvalidSnapshotStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSnapshotStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSnapshotStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSnapshotStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSnapshotState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSnapshotStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An invalid subnet identifier was specified.
type InvalidSubnet struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSubnet) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSubnet) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSubnet) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSubnet"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSubnet) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user group is not in an active state.
type InvalidUserGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidUserGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUserGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUserGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidUserGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidUserGroupStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user is not in active state.
type InvalidUserStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidUserStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUserStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUserStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidUserState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidUserStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The VPC network is in an invalid state.
type InvalidVPCNetworkStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidVPCNetworkStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidVPCNetworkStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidVPCNetworkStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidVPCNetworkStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidVPCNetworkStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The node group specified by the NodeGroupId parameter could not be found.
// Please verify that the node group exists and that you spelled the NodeGroupId
// value correctly.
type NodeGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NodeGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NodeGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NodeGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NodeGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *NodeGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the maximum allowed
// number of node groups (shards) in a single replication group. The default
// maximum is 90
type NodeGroupsPerReplicationGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NodeGroupsPerReplicationGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NodeGroupsPerReplicationGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NodeGroupsPerReplicationGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NodeGroupsPerReplicationGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *NodeGroupsPerReplicationGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request cannot be processed because it would exceed the allowed number of
// cache nodes in a single cluster.
type NodeQuotaForClusterExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NodeQuotaForClusterExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NodeQuotaForClusterExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NodeQuotaForClusterExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NodeQuotaForClusterExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *NodeQuotaForClusterExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the allowed number of
// cache nodes per customer.
type NodeQuotaForCustomerExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NodeQuotaForCustomerExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NodeQuotaForCustomerExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NodeQuotaForCustomerExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NodeQuotaForCustomerExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *NodeQuotaForCustomerExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation was not performed because no changes were required.
type NoOperationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoOperationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoOperationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoOperationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoOperationFault"
	}
	return *e.ErrorCodeOverride
}
func (e *NoOperationFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified replication group already exists.
type ReplicationGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReplicationGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReplicationGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReplicationGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReplicationGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ReplicationGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The targeted replication group is not available.
type ReplicationGroupAlreadyUnderMigrationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReplicationGroupAlreadyUnderMigrationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReplicationGroupAlreadyUnderMigrationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReplicationGroupAlreadyUnderMigrationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReplicationGroupAlreadyUnderMigrationFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ReplicationGroupAlreadyUnderMigrationFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified replication group does not exist.
type ReplicationGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReplicationGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReplicationGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReplicationGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReplicationGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ReplicationGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The designated replication group is not available for data migration.
type ReplicationGroupNotUnderMigrationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReplicationGroupNotUnderMigrationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReplicationGroupNotUnderMigrationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReplicationGroupNotUnderMigrationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReplicationGroupNotUnderMigrationFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ReplicationGroupNotUnderMigrationFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You already have a reservation with the given identifier.
type ReservedCacheNodeAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedCacheNodeAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedCacheNodeAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedCacheNodeAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedCacheNodeAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedCacheNodeAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested reserved cache node was not found.
type ReservedCacheNodeNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedCacheNodeNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedCacheNodeNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedCacheNodeNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedCacheNodeNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedCacheNodeNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the user's cache node
// quota.
type ReservedCacheNodeQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedCacheNodeQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedCacheNodeQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedCacheNodeQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedCacheNodeQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedCacheNodeQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested cache node offering does not exist.
type ReservedCacheNodesOfferingNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedCacheNodesOfferingNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedCacheNodesOfferingNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedCacheNodesOfferingNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedCacheNodesOfferingNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedCacheNodesOfferingNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A serverless cache with this name already exists.
type ServerlessCacheAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServerlessCacheAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerlessCacheAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerlessCacheAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerlessCacheAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerlessCacheAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The serverless cache was not found or does not exist.
type ServerlessCacheNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServerlessCacheNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerlessCacheNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerlessCacheNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerlessCacheNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerlessCacheNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of serverless caches exceeds the customer quota.
type ServerlessCacheQuotaForCustomerExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServerlessCacheQuotaForCustomerExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerlessCacheQuotaForCustomerExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerlessCacheQuotaForCustomerExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerlessCacheQuotaForCustomerExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerlessCacheQuotaForCustomerExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A serverless cache snapshot with this name already exists. Available for
// Valkey, Redis OSS and Serverless Memcached only.
type ServerlessCacheSnapshotAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServerlessCacheSnapshotAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerlessCacheSnapshotAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerlessCacheSnapshotAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerlessCacheSnapshotAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerlessCacheSnapshotAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This serverless cache snapshot could not be found or does not exist. Available
// for Valkey, Redis OSS and Serverless Memcached only.
type ServerlessCacheSnapshotNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServerlessCacheSnapshotNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerlessCacheSnapshotNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerlessCacheSnapshotNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerlessCacheSnapshotNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerlessCacheSnapshotNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The number of serverless cache snapshots exceeds the customer snapshot quota.
// Available for Valkey, Redis OSS and Serverless Memcached only.
type ServerlessCacheSnapshotQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServerlessCacheSnapshotQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerlessCacheSnapshotQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerlessCacheSnapshotQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServerlessCacheSnapshotQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServerlessCacheSnapshotQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified service linked role (SLR) was not found.
type ServiceLinkedRoleNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceLinkedRoleNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceLinkedRoleNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceLinkedRoleNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceLinkedRoleNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceLinkedRoleNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The service update doesn't exist
type ServiceUpdateNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceUpdateNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceUpdateNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceUpdateNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceUpdateNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceUpdateNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You already have a snapshot with the given name.
type SnapshotAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You attempted one of the following operations:
//
//   - Creating a snapshot of a Valkey or Redis OSS cluster running on a
//     cache.t1.micro cache node.
//
//   - Creating a snapshot of a cluster that is running Memcached rather than
//     Valkey or Redis OSS.
//
// Neither of these are supported by ElastiCache.
type SnapshotFeatureNotSupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotFeatureNotSupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotFeatureNotSupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotFeatureNotSupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotFeatureNotSupportedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotFeatureNotSupportedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested snapshot name does not refer to an existing snapshot.
type SnapshotNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would exceed the maximum number of
// snapshots.
type SnapshotQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested subnet is being used by another cache subnet group.
type SubnetInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubnetInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubnetInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubnetInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubnetInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *SubnetInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// At least one subnet ID does not match the other subnet IDs. This mismatch
// typically occurs when a user sets one subnet ID to a regional Availability Zone
// and a different one to an outpost. Or when a user sets the subnet ID to an
// Outpost when not subscribed on this service.
type SubnetNotAllowedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubnetNotAllowedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubnetNotAllowedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubnetNotAllowedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubnetNotAllowedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SubnetNotAllowedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested tag was not found on this resource.
type TagNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TagNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *TagNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request cannot be processed because it would cause the resource to have
// more than the allowed number of tags. The maximum number of tags permitted on a
// resource is 50.
type TagQuotaPerResourceExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagQuotaPerResourceExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagQuotaPerResourceExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagQuotaPerResourceExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TagQuotaPerResourceExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *TagQuotaPerResourceExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The TestFailover action is not available.
type TestFailoverNotAvailableFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TestFailoverNotAvailableFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TestFailoverNotAvailableFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TestFailoverNotAvailableFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TestFailoverNotAvailableFault"
	}
	return *e.ErrorCodeOverride
}
func (e *TestFailoverNotAvailableFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A user with this ID already exists.
type UserAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UserAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UserAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UserAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UserAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *UserAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user group with this ID already exists.
type UserGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UserGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UserGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UserGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UserGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *UserGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user group was not found or does not exist
type UserGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UserGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UserGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UserGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UserGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *UserGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of users exceeds the user group limit.
type UserGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UserGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UserGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UserGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UserGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *UserGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user does not exist or could not be found.
type UserNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UserNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UserNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UserNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UserNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *UserNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The quota of users has been exceeded.
type UserQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UserQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UserQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UserQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UserQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *UserQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
