// Code generated by smithy-go-codegen DO NOT EDIT.

package dsql

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/dsql/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// The CreateCluster API allows you to create both single-Region clusters and
// multi-Region clusters. With the addition of the multiRegionProperties parameter,
// you can create a cluster with witness Region support and establish peer
// relationships with clusters in other Regions during creation.
//
// Creating multi-Region clusters requires additional IAM permissions beyond those
// needed for single-Region clusters, as detailed in the Required permissions
// section below.
//
// # Required permissions
//
// dsql:CreateCluster Required to create a cluster.
//
// Resources: arn:aws:dsql:region:account-id:cluster/*
//
// dsql:TagResource Permission to add tags to a resource.
//
// Resources: arn:aws:dsql:region:account-id:cluster/*
//
// dsql:PutMultiRegionProperties Permission to configure multi-Region properties
// for a cluster.
//
// Resources: arn:aws:dsql:region:account-id:cluster/*
//
// dsql:AddPeerCluster When specifying multiRegionProperties.clusters , permission
// to add peer clusters.
//
// Resources:
//
//   - Local cluster: arn:aws:dsql:region:account-id:cluster/*
//
//   - Each peer cluster: exact ARN of each specified peer cluster
//
// dsql:PutWitnessRegion When specifying multiRegionProperties.witnessRegion ,
// permission to set a witness Region. This permission is checked both in the
// cluster Region and in the witness Region.
//
// Resources: arn:aws:dsql:region:account-id:cluster/*
//
// Condition Keys: dsql:WitnessRegion (matching the specified witness region)
//
//   - The witness Region specified in multiRegionProperties.witnessRegion cannot
//     be the same as the cluster's Region.
func (c *Client) CreateCluster(ctx context.Context, params *CreateClusterInput, optFns ...func(*Options)) (*CreateClusterOutput, error) {
	if params == nil {
		params = &CreateClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCluster", params, optFns, c.addOperationCreateClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateClusterInput struct {

	// An optional field that controls whether to bypass the lockout prevention check.
	// When set to true, this parameter allows you to apply a policy that might lock
	// you out of the cluster. Use with caution.
	BypassPolicyLockoutSafetyCheck bool

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully, the
	// subsequent retries with the same client token return the result from the
	// original successful request and they have no additional effect.
	//
	// If you don't specify a client token, the Amazon Web Services SDK automatically
	// generates one.
	ClientToken *string

	// If enabled, you can't delete your cluster. You must first disable this property
	// before you can delete your cluster.
	DeletionProtectionEnabled *bool

	// The KMS key that encrypts and protects the data on your cluster. You can
	// specify the ARN, ID, or alias of an existing key or have Amazon Web Services
	// create a default key for you.
	KmsEncryptionKey *string

	// The configuration settings when creating a multi-Region cluster, including the
	// witness region and linked cluster properties.
	MultiRegionProperties *types.MultiRegionProperties

	// An optional resource-based policy document in JSON format that defines access
	// permissions for the cluster.
	Policy *string

	// A map of key and value pairs to use to tag your cluster.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The output of a created cluster.
type CreateClusterOutput struct {

	// The ARN of the created cluster.
	//
	// This member is required.
	Arn *string

	// The time of when created the cluster.
	//
	// This member is required.
	CreationTime *time.Time

	// Whether deletion protection is enabled on this cluster.
	//
	// This member is required.
	DeletionProtectionEnabled *bool

	// The ID of the created cluster.
	//
	// This member is required.
	Identifier *string

	// The status of the created cluster.
	//
	// This member is required.
	Status types.ClusterStatus

	// The encryption configuration for the cluster that was specified during the
	// creation process, including the KMS key identifier and encryption state.
	EncryptionDetails *types.EncryptionDetails

	// The connection endpoint for the created cluster.
	Endpoint *string

	// The multi-Region cluster configuration details that were set during cluster
	// creation
	MultiRegionProperties *types.MultiRegionProperties

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateClusterMiddleware(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateCluster struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateCluster) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateCluster) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateClusterInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateClusterInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateClusterMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateCluster{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCluster",
	}
}
