// Code generated by smithy-go-codegen DO NOT EDIT.

package dlm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/dlm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon Data Lifecycle Manager lifecycle policy. Amazon Data
// Lifecycle Manager supports the following policy types:
//
//   - Custom EBS snapshot policy
//
//   - Custom EBS-backed AMI policy
//
//   - Cross-account copy event policy
//
//   - Default policy for EBS snapshots
//
//   - Default policy for EBS-backed AMIs
//
// For more information, see [Default policies vs custom policies].
//
// If you create a default policy, you can specify the request parameters either
// in the request body, or in the PolicyDetails request structure, but not both.
//
// [Default policies vs custom policies]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/policy-differences.html
func (c *Client) CreateLifecyclePolicy(ctx context.Context, params *CreateLifecyclePolicyInput, optFns ...func(*Options)) (*CreateLifecyclePolicyOutput, error) {
	if params == nil {
		params = &CreateLifecyclePolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLifecyclePolicy", params, optFns, c.addOperationCreateLifecyclePolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLifecyclePolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLifecyclePolicyInput struct {

	// A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are
	// supported.
	//
	// This member is required.
	Description *string

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	//
	// This member is required.
	ExecutionRoleArn *string

	// The activation state of the lifecycle policy after creation.
	//
	// This member is required.
	State types.SettablePolicyStateValues

	//  [Default policies only] Indicates whether the policy should copy tags from the
	// source resource to the snapshot or AMI. If you do not specify a value, the
	// default is false .
	//
	// Default: false
	CopyTags *bool

	//  [Default policies only] Specifies how often the policy should run and create
	// snapshots or AMIs. The creation frequency can range from 1 to 7 days. If you do
	// not specify a value, the default is 1.
	//
	// Default: 1
	CreateInterval *int32

	//  [Default policies only] Specifies destination Regions for snapshot or AMI
	// copies. You can specify up to 3 destination Regions. If you do not want to
	// create cross-Region copies, omit this parameter.
	CrossRegionCopyTargets []types.CrossRegionCopyTarget

	//  [Default policies only] Specify the type of default policy to create.
	//
	//   - To create a default policy for EBS snapshots, that creates snapshots of all
	//   volumes in the Region that do not have recent backups, specify VOLUME .
	//
	//   - To create a default policy for EBS-backed AMIs, that creates EBS-backed
	//   AMIs from all instances in the Region that do not have recent backups, specify
	//   INSTANCE .
	DefaultPolicy types.DefaultPolicyTypeValues

	//  [Default policies only] Specifies exclusion parameters for volumes or
	// instances for which you do not want to create snapshots or AMIs. The policy will
	// not create snapshots or AMIs for target resources that match any of the
	// specified exclusion parameters.
	Exclusions *types.Exclusions

	//  [Default policies only] Defines the snapshot or AMI retention behavior for the
	// policy if the source volume or instance is deleted, or if the policy enters the
	// error, disabled, or deleted state.
	//
	// By default (ExtendDeletion=false):
	//
	//   - If a source resource is deleted, Amazon Data Lifecycle Manager will
	//   continue to delete previously created snapshots or AMIs, up to but not including
	//   the last one, based on the specified retention period. If you want Amazon Data
	//   Lifecycle Manager to delete all snapshots or AMIs, including the last one,
	//   specify true .
	//
	//   - If a policy enters the error, disabled, or deleted state, Amazon Data
	//   Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data
	//   Lifecycle Manager to continue deleting snapshots or AMIs, including the last
	//   one, if the policy enters one of these states, specify true .
	//
	// If you enable extended deletion (ExtendDeletion=true), you override both
	// default behaviors simultaneously.
	//
	// If you do not specify a value, the default is false .
	//
	// Default: false
	ExtendDeletion *bool

	// The configuration details of the lifecycle policy.
	//
	// If you create a default policy, you can specify the request parameters either
	// in the request body, or in the PolicyDetails request structure, but not both.
	PolicyDetails *types.PolicyDetails

	//  [Default policies only] Specifies how long the policy should retain snapshots
	// or AMIs before deleting them. The retention period can range from 2 to 14 days,
	// but it must be greater than the creation frequency to ensure that the policy
	// retains at least 1 snapshot or AMI at any given time. If you do not specify a
	// value, the default is 7.
	//
	// Default: 7
	RetainInterval *int32

	// The tags to apply to the lifecycle policy during creation.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateLifecyclePolicyOutput struct {

	// The identifier of the lifecycle policy.
	PolicyId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLifecyclePolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateLifecyclePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateLifecyclePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLifecyclePolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLifecyclePolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLifecyclePolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLifecyclePolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLifecyclePolicy",
	}
}
