// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an environment blueprint in Amazon DataZone.
func (c *Client) UpdateEnvironmentBlueprint(ctx context.Context, params *UpdateEnvironmentBlueprintInput, optFns ...func(*Options)) (*UpdateEnvironmentBlueprintOutput, error) {
	if params == nil {
		params = &UpdateEnvironmentBlueprintInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateEnvironmentBlueprint", params, optFns, c.addOperationUpdateEnvironmentBlueprintMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateEnvironmentBlueprintOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateEnvironmentBlueprintInput struct {

	// The identifier of the Amazon DataZone domain in which an environment blueprint
	// is to be updated.
	//
	// This member is required.
	DomainIdentifier *string

	// The identifier of the environment blueprint to be updated.
	//
	// This member is required.
	Identifier *string

	// The description to be updated as part of the UpdateEnvironmentBlueprint action.
	Description *string

	// The provisioning properties to be updated as part of the
	// UpdateEnvironmentBlueprint action.
	ProvisioningProperties types.ProvisioningProperties

	// The user parameters to be updated as part of the UpdateEnvironmentBlueprint
	// action.
	UserParameters []types.CustomParameter

	noSmithyDocumentSerde
}

type UpdateEnvironmentBlueprintOutput struct {

	// The identifier of the blueprint to be updated.
	//
	// This member is required.
	Id *string

	// The name to be updated as part of the UpdateEnvironmentBlueprint action.
	//
	// This member is required.
	Name *string

	// The provider of the blueprint to be udpated.
	//
	// This member is required.
	Provider *string

	// The provisioning properties to be updated as part of the
	// UpdateEnvironmentBlueprint action.
	//
	// This member is required.
	ProvisioningProperties types.ProvisioningProperties

	// The timestamp of when the environment blueprint was created.
	CreatedAt *time.Time

	// The deployment properties to be updated as part of the
	// UpdateEnvironmentBlueprint action.
	DeploymentProperties *types.DeploymentProperties

	// The description to be updated as part of the UpdateEnvironmentBlueprint action.
	Description *string

	// The glossary terms to be updated as part of the UpdateEnvironmentBlueprint
	// action.
	GlossaryTerms []string

	// The timestamp of when the blueprint was updated.
	UpdatedAt *time.Time

	// The user parameters to be updated as part of the UpdateEnvironmentBlueprint
	// action.
	UserParameters []types.CustomParameter

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateEnvironmentBlueprintMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateEnvironmentBlueprint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateEnvironmentBlueprint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateEnvironmentBlueprint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateEnvironmentBlueprintValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateEnvironmentBlueprint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateEnvironmentBlueprint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateEnvironmentBlueprint",
	}
}
