// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an account pool.
func (c *Client) CreateAccountPool(ctx context.Context, params *CreateAccountPoolInput, optFns ...func(*Options)) (*CreateAccountPoolOutput, error) {
	if params == nil {
		params = &CreateAccountPoolInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAccountPool", params, optFns, c.addOperationCreateAccountPoolMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAccountPoolOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAccountPoolInput struct {

	// The source of accounts for the account pool. In the current release, it's
	// either a static list of accounts provided by the customer or a custom Amazon Web
	// Services Lambda handler.
	//
	// This member is required.
	AccountSource types.AccountSource

	// The ID of the domain where the account pool is created.
	//
	// This member is required.
	DomainIdentifier *string

	// The name of the account pool.
	//
	// This member is required.
	Name *string

	// The mechanism used to resolve the account selection from the account pool.
	//
	// This member is required.
	ResolutionStrategy types.ResolutionStrategy

	// The description of the account pool.
	Description *string

	noSmithyDocumentSerde
}

type CreateAccountPoolOutput struct {

	// The source of accounts for the account pool. In the current release, it's
	// either a static list of accounts provided by the customer or a custom Amazon Web
	// Services Lambda handler.
	//
	// This member is required.
	AccountSource types.AccountSource

	// The user who created the account pool.
	//
	// This member is required.
	CreatedBy *string

	// The timestamp at which the account pool was created.
	CreatedAt *time.Time

	// The description of the account pool.
	Description *string

	// The ID of the domain where the account pool is created.
	DomainId *string

	// The ID of the domain where the account pool is created.
	DomainUnitId *string

	// The ID of the account pool.
	Id *string

	// The timestamp at which the account pool was last updated.
	LastUpdatedAt *time.Time

	// The name of the account pool.
	Name *string

	// The mechanism used to resolve the account selection from the account pool.
	ResolutionStrategy types.ResolutionStrategy

	// The user who last updated the account pool.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAccountPoolMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAccountPool"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAccountPoolValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAccountPool(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateAccountPool(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAccountPool",
	}
}
