// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Cancels the subscription to the specified asset.
func (c *Client) CancelSubscription(ctx context.Context, params *CancelSubscriptionInput, optFns ...func(*Options)) (*CancelSubscriptionOutput, error) {
	if params == nil {
		params = &CancelSubscriptionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CancelSubscription", params, optFns, c.addOperationCancelSubscriptionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CancelSubscriptionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CancelSubscriptionInput struct {

	// The unique identifier of the Amazon DataZone domain where the subscription
	// request is being cancelled.
	//
	// This member is required.
	DomainIdentifier *string

	// The unique identifier of the subscription that is being cancelled.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type CancelSubscriptionOutput struct {

	// The timestamp that specifies when the request to cancel the subscription was
	// created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Specifies the Amazon DataZone user who is cancelling the subscription.
	//
	// This member is required.
	CreatedBy *string

	// The unique identifier of the Amazon DataZone domain where the subscription is
	// being cancelled.
	//
	// This member is required.
	DomainId *string

	// The identifier of the subscription.
	//
	// This member is required.
	Id *string

	// The status of the request to cancel the subscription.
	//
	// This member is required.
	Status types.SubscriptionStatus

	// The asset to which a subscription is being cancelled.
	//
	// This member is required.
	SubscribedListing *types.SubscribedListing

	// The Amazon DataZone user who is made a subscriber to the specified asset by the
	// subscription that is being cancelled.
	//
	// This member is required.
	SubscribedPrincipal types.SubscribedPrincipal

	// The timestamp that specifies when the subscription was cancelled.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Specifies whether the permissions to the asset are retained after the
	// subscription is cancelled.
	RetainPermissions *bool

	// The unique ID of the subscripton request for the subscription that is being
	// cancelled.
	SubscriptionRequestId *string

	// The Amazon DataZone user that cancelled the subscription.
	UpdatedBy *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCancelSubscriptionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCancelSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCancelSubscription{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CancelSubscription"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCancelSubscriptionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCancelSubscription(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCancelSubscription(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CancelSubscription",
	}
}
