// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the following configuration parameters of the Amazon S3 transfer
// location that you're using with DataSync.
//
// Before you begin, make sure that you read the following topics:
//
// [Storage class considerations with Amazon S3 locations]
//
// [Evaluating S3 request costs when using DataSync]
//
// [Storage class considerations with Amazon S3 locations]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes
// [Evaluating S3 request costs when using DataSync]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-s3-requests
func (c *Client) UpdateLocationS3(ctx context.Context, params *UpdateLocationS3Input, optFns ...func(*Options)) (*UpdateLocationS3Output, error) {
	if params == nil {
		params = &UpdateLocationS3Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLocationS3", params, optFns, c.addOperationUpdateLocationS3Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLocationS3Output)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLocationS3Input struct {

	// Specifies the Amazon Resource Name (ARN) of the Amazon S3 transfer location
	// that you're updating.
	//
	// This member is required.
	LocationArn *string

	// Specifies the Amazon Resource Name (ARN) of the Identity and Access Management
	// (IAM) role that DataSync uses to access your S3 bucket.
	//
	// For more information, see [Providing DataSync access to S3 buckets].
	//
	// [Providing DataSync access to S3 buckets]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access
	S3Config *types.S3Config

	// Specifies the storage class that you want your objects to use when Amazon S3 is
	// a transfer destination.
	//
	// For buckets in Amazon Web Services Regions, the storage class defaults to
	// STANDARD . For buckets on Outposts, the storage class defaults to OUTPOSTS .
	//
	// For more information, see [Storage class considerations with Amazon S3 transfers].
	//
	// [Storage class considerations with Amazon S3 transfers]: https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes
	S3StorageClass types.S3StorageClass

	// Specifies a prefix in the S3 bucket that DataSync reads from or writes to
	// (depending on whether the bucket is a source or destination location).
	//
	// DataSync can't transfer objects with a prefix that begins with a slash ( / ) or
	// includes // , /./ , or /../ patterns. For example:
	//
	//   - /photos
	//
	//   - photos//2006/January
	//
	//   - photos/./2006/February
	//
	//   - photos/../2006/March
	Subdirectory *string

	noSmithyDocumentSerde
}

type UpdateLocationS3Output struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLocationS3Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateLocationS3{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateLocationS3{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateLocationS3"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateLocationS3ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLocationS3(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLocationS3(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateLocationS3",
	}
}
