// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a transfer location for an object storage system. DataSync can use this
// location as a source or destination for transferring data. You can make
// transfers with or without a [DataSync agent].
//
// Before you begin, make sure that you understand the [prerequisites] for DataSync to work with
// object storage systems.
//
// [DataSync agent]: https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html#when-agent-required
// [prerequisites]: https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html#create-object-location-prerequisites
func (c *Client) CreateLocationObjectStorage(ctx context.Context, params *CreateLocationObjectStorageInput, optFns ...func(*Options)) (*CreateLocationObjectStorageOutput, error) {
	if params == nil {
		params = &CreateLocationObjectStorageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLocationObjectStorage", params, optFns, c.addOperationCreateLocationObjectStorageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLocationObjectStorageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// CreateLocationObjectStorageRequest
type CreateLocationObjectStorageInput struct {

	// Specifies the name of the object storage bucket involved in the transfer.
	//
	// This member is required.
	BucketName *string

	// Specifies the domain name or IP address (IPv4 or IPv6) of the object storage
	// server that your DataSync agent connects to.
	//
	// This member is required.
	ServerHostname *string

	// Specifies the access key (for example, a user name) if credentials are required
	// to authenticate with the object storage server.
	AccessKey *string

	// (Optional) Specifies the Amazon Resource Names (ARNs) of the DataSync agents
	// that can connect with your object storage system. If you are setting up an
	// agentless cross-cloud transfer, you do not need to specify a value for this
	// parameter.
	//
	// Make sure you configure this parameter correctly when you first create your
	// storage location. You cannot add or remove agents from a storage location after
	// you create it.
	AgentArns []string

	// Specifies configuration information for a DataSync-managed secret, which
	// includes the SecretKey that DataSync uses to access a specific object storage
	// location, with a customer-managed KMS key.
	//
	// When you include this paramater as part of a CreateLocationObjectStorage
	// request, you provide only the KMS key ARN. DataSync uses this KMS key together
	// with the value you specify for the SecretKey parameter to create a
	// DataSync-managed secret to store the location access credentials.
	//
	// Make sure the DataSync has permission to access the KMS key that you specify.
	//
	// You can use either CmkSecretConfig (with SecretKey ) or CustomSecretConfig
	// (without SecretKey ) to provide credentials for a CreateLocationObjectStorage
	// request. Do not provide both parameters for the same request.
	CmkSecretConfig *types.CmkSecretConfig

	// Specifies configuration information for a customer-managed Secrets Manager
	// secret where the secret key for a specific object storage location is stored in
	// plain text. This configuration includes the secret ARN, and the ARN for an IAM
	// role that provides access to the secret.
	//
	// You can use either CmkSecretConfig (with SecretKey ) or CustomSecretConfig
	// (without SecretKey ) to provide credentials for a CreateLocationObjectStorage
	// request. Do not provide both parameters for the same request.
	CustomSecretConfig *types.CustomSecretConfig

	// Specifies the secret key (for example, a password) if credentials are required
	// to authenticate with the object storage server.
	//
	// If you provide a secret using SecretKey , but do not provide secret
	// configuration details using CmkSecretConfig or CustomSecretConfig , then
	// DataSync stores the token using your Amazon Web Services account's Secrets
	// Manager secret.
	SecretKey *string

	// Specifies a certificate chain for DataSync to authenticate with your object
	// storage system if the system uses a private or self-signed certificate authority
	// (CA). You must specify a single .pem file with a full certificate chain (for
	// example, file:///home/user/.ssh/object_storage_certificates.pem ).
	//
	// The certificate chain might include:
	//
	//   - The object storage system's certificate
	//
	//   - All intermediate certificates (if there are any)
	//
	//   - The root certificate of the signing CA
	//
	// You can concatenate your certificates into a .pem file (which can be up to
	// 32768 bytes before base64 encoding). The following example cat command creates
	// an object_storage_certificates.pem file that includes three certificates:
	//
	//     cat object_server_certificate.pem intermediate_certificate.pem
	//     ca_root_certificate.pem > object_storage_certificates.pem
	//
	// To use this parameter, configure ServerProtocol to HTTPS .
	ServerCertificate []byte

	// Specifies the port that your object storage server accepts inbound network
	// traffic on (for example, port 443).
	ServerPort *int32

	// Specifies the protocol that your object storage server uses to communicate. If
	// not specified, the default value is HTTPS .
	ServerProtocol types.ObjectStorageServerProtocol

	// Specifies the object prefix for your object storage server. If this is a source
	// location, DataSync only copies objects with this prefix. If this is a
	// destination location, DataSync writes all objects with this prefix.
	Subdirectory *string

	// Specifies the key-value pair that represents a tag that you want to add to the
	// resource. Tags can help you manage, filter, and search for your resources. We
	// recommend creating a name tag for your location.
	Tags []types.TagListEntry

	noSmithyDocumentSerde
}

// CreateLocationObjectStorageResponse
type CreateLocationObjectStorageOutput struct {

	// Specifies the ARN of the object storage system location that you create.
	LocationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLocationObjectStorageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateLocationObjectStorage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateLocationObjectStorage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLocationObjectStorage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLocationObjectStorageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLocationObjectStorage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLocationObjectStorage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLocationObjectStorage",
	}
}
