// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a transfer location for a Microsoft Azure Blob Storage container.
// DataSync can use this location as a transfer source or destination. You can make
// transfers with or without a [DataSync agent]that connects to your container.
//
// Before you begin, make sure you know [how DataSync accesses Azure Blob Storage] and works with [access tiers] and [blob types].
//
// [DataSync agent]: https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-creating-agent
// [blob types]: https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#blob-types
// [how DataSync accesses Azure Blob Storage]: https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access
// [access tiers]: https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers
func (c *Client) CreateLocationAzureBlob(ctx context.Context, params *CreateLocationAzureBlobInput, optFns ...func(*Options)) (*CreateLocationAzureBlobOutput, error) {
	if params == nil {
		params = &CreateLocationAzureBlobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLocationAzureBlob", params, optFns, c.addOperationCreateLocationAzureBlobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLocationAzureBlobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLocationAzureBlobInput struct {

	// Specifies the authentication method DataSync uses to access your Azure Blob
	// Storage. DataSync can access blob storage using a shared access signature (SAS).
	//
	// This member is required.
	AuthenticationType types.AzureBlobAuthenticationType

	// Specifies the URL of the Azure Blob Storage container involved in your transfer.
	//
	// This member is required.
	ContainerUrl *string

	// Specifies the access tier that you want your objects or files transferred into.
	// This only applies when using the location as a transfer destination. For more
	// information, see [Access tiers].
	//
	// [Access tiers]: https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-access-tiers
	AccessTier types.AzureAccessTier

	// (Optional) Specifies the Amazon Resource Name (ARN) of the DataSync agent that
	// can connect with your Azure Blob Storage container. If you are setting up an
	// agentless cross-cloud transfer, you do not need to specify a value for this
	// parameter.
	//
	// You can specify more than one agent. For more information, see [Using multiple agents for your transfer].
	//
	// Make sure you configure this parameter correctly when you first create your
	// storage location. You cannot add or remove agents from a storage location after
	// you create it.
	//
	// [Using multiple agents for your transfer]: https://docs.aws.amazon.com/datasync/latest/userguide/multiple-agents.html
	AgentArns []string

	// Specifies the type of blob that you want your objects or files to be when
	// transferring them into Azure Blob Storage. Currently, DataSync only supports
	// moving data into Azure Blob Storage as block blobs. For more information on blob
	// types, see the [Azure Blob Storage documentation].
	//
	// [Azure Blob Storage documentation]: https://learn.microsoft.com/en-us/rest/api/storageservices/understanding-block-blobs--append-blobs--and-page-blobs
	BlobType types.AzureBlobType

	// Specifies configuration information for a DataSync-managed secret, which
	// includes the authentication token that DataSync uses to access a specific
	// AzureBlob storage location, with a customer-managed KMS key.
	//
	// When you include this paramater as part of a CreateLocationAzureBlob request,
	// you provide only the KMS key ARN. DataSync uses this KMS key together with the
	// authentication token you specify for SasConfiguration to create a
	// DataSync-managed secret to store the location access credentials.
	//
	// Make sure the DataSync has permission to access the KMS key that you specify.
	//
	// You can use either CmkSecretConfig (with SasConfiguration ) or
	// CustomSecretConfig (without SasConfiguration ) to provide credentials for a
	// CreateLocationAzureBlob request. Do not provide both parameters for the same
	// request.
	CmkSecretConfig *types.CmkSecretConfig

	// Specifies configuration information for a customer-managed Secrets Manager
	// secret where the authentication token for an AzureBlob storage location is
	// stored in plain text. This configuration includes the secret ARN, and the ARN
	// for an IAM role that provides access to the secret.
	//
	// You can use either CmkSecretConfig (with SasConfiguration ) or
	// CustomSecretConfig (without SasConfiguration ) to provide credentials for a
	// CreateLocationAzureBlob request. Do not provide both parameters for the same
	// request.
	CustomSecretConfig *types.CustomSecretConfig

	// Specifies the SAS configuration that allows DataSync to access your Azure Blob
	// Storage.
	//
	// If you provide an authentication token using SasConfiguration , but do not
	// provide secret configuration details using CmkSecretConfig or CustomSecretConfig
	// , then DataSync stores the token using your Amazon Web Services account's
	// secrets manager secret.
	SasConfiguration *types.AzureBlobSasConfiguration

	// Specifies path segments if you want to limit your transfer to a virtual
	// directory in your container (for example, /my/images ).
	Subdirectory *string

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// transfer location.
	Tags []types.TagListEntry

	noSmithyDocumentSerde
}

type CreateLocationAzureBlobOutput struct {

	// The ARN of the Azure Blob Storage transfer location that you created.
	LocationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLocationAzureBlobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateLocationAzureBlob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateLocationAzureBlob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLocationAzureBlob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLocationAzureBlobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLocationAzureBlob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLocationAzureBlob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLocationAzureBlob",
	}
}
