// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Activates an DataSync agent that you deploy in your storage environment. The
// activation process associates the agent with your Amazon Web Services account.
//
// If you haven't deployed an agent yet, see [Do I need a DataSync agent?]
//
// [Do I need a DataSync agent?]: https://docs.aws.amazon.com/datasync/latest/userguide/do-i-need-datasync-agent.html
func (c *Client) CreateAgent(ctx context.Context, params *CreateAgentInput, optFns ...func(*Options)) (*CreateAgentOutput, error) {
	if params == nil {
		params = &CreateAgentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAgent", params, optFns, c.addOperationCreateAgentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAgentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// CreateAgentRequest
type CreateAgentInput struct {

	// Specifies your DataSync agent's activation key. If you don't have an activation
	// key, see [Activating your agent].
	//
	// [Activating your agent]: https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html
	//
	// This member is required.
	ActivationKey *string

	// Specifies a name for your agent. We recommend specifying a name that you can
	// remember.
	AgentName *string

	// Specifies the Amazon Resource Name (ARN) of the security group that allows
	// traffic between your agent and VPC service endpoint. You can only specify one
	// ARN.
	SecurityGroupArns []string

	// Specifies the ARN of the subnet where your VPC service endpoint is located. You
	// can only specify one ARN.
	SubnetArns []string

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least one tag for your agent.
	Tags []types.TagListEntry

	// Specifies the ID of the [VPC service endpoint] that you're using. For example, a VPC endpoint ID
	// looks like vpce-01234d5aff67890e1 .
	//
	// The VPC service endpoint you use must include the DataSync service name (for
	// example, com.amazonaws.us-east-2.datasync ).
	//
	// [VPC service endpoint]: https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#datasync-in-vpc
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// CreateAgentResponse
type CreateAgentOutput struct {

	// The ARN of the agent that you just activated. Use the [ListAgents] operation to return a
	// list of agents in your Amazon Web Services account and Amazon Web Services
	// Region.
	//
	// [ListAgents]: https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html
	AgentArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAgentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateAgent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateAgent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAgent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAgentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAgent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateAgent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAgent",
	}
}
