// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Create/Update a DomainObjectType in a Customer Profiles domain. To create a new
// DomainObjectType, Data Store needs to be enabled on the Domain.
func (c *Client) PutDomainObjectType(ctx context.Context, params *PutDomainObjectTypeInput, optFns ...func(*Options)) (*PutDomainObjectTypeOutput, error) {
	if params == nil {
		params = &PutDomainObjectTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutDomainObjectType", params, optFns, c.addOperationPutDomainObjectTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutDomainObjectTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutDomainObjectTypeInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// A map of field names to their corresponding domain object type field
	// definitions.
	//
	// This member is required.
	Fields map[string]types.DomainObjectTypeField

	// The unique name of the domain object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The description of the domain object type.
	Description *string

	// The customer provided KMS key used to encrypt this type of domain object.
	EncryptionKey *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type PutDomainObjectTypeOutput struct {

	// The timestamp of when the domain object type was created.
	CreatedAt *time.Time

	// The description of the domain object type.
	Description *string

	// The customer provided KMS key used to encrypt this type of domain object.
	EncryptionKey *string

	// A map of field names to their corresponding domain object type field
	// definitions.
	Fields map[string]types.DomainObjectTypeField

	// The timestamp of when the domain object type was most recently edited.
	LastUpdatedAt *time.Time

	// The unique name of the domain object type.
	ObjectTypeName *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutDomainObjectTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutDomainObjectType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutDomainObjectType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutDomainObjectType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutDomainObjectTypeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutDomainObjectType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutDomainObjectType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutDomainObjectType",
	}
}
