// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves a recommender.
func (c *Client) GetRecommender(ctx context.Context, params *GetRecommenderInput, optFns ...func(*Options)) (*GetRecommenderOutput, error) {
	if params == nil {
		params = &GetRecommenderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRecommender", params, optFns, c.addOperationGetRecommenderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRecommenderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetRecommenderInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The name of the recommender.
	//
	// This member is required.
	RecommenderName *string

	// The number of training metrics to retrieve for the recommender.
	TrainingMetricsCount *int32

	noSmithyDocumentSerde
}

type GetRecommenderOutput struct {

	// The name of the recommender.
	//
	// This member is required.
	RecommenderName *string

	// The name of the recipe used by the recommender to generate recommendations.
	//
	// This member is required.
	RecommenderRecipeName types.RecommenderRecipeName

	// The timestamp of when the recommender was created.
	CreatedAt *time.Time

	// A detailed description of the recommender providing information about its
	// purpose and functionality.
	Description *string

	// If the recommender fails, provides the reason for the failure.
	FailureReason *string

	// The timestamp of when the recommender was edited.
	LastUpdatedAt *time.Time

	// Information about the most recent update performed on the recommender,
	// including status and timestamp.
	LatestRecommenderUpdate *types.RecommenderUpdate

	// The configuration settings for the recommender, including parameters and
	// settings that define its behavior.
	RecommenderConfig *types.RecommenderConfig

	// The current status of the recommender, indicating whether it is active,
	// creating, updating, or in another state.
	Status types.RecommenderStatus

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// A set of metrics that provide information about the recommender's training
	// performance and accuracy.
	TrainingMetrics []types.TrainingMetrics

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRecommenderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetRecommender{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetRecommender{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRecommender"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetRecommenderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRecommender(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRecommender(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRecommender",
	}
}
