// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about an Identity Resolution Job in a specific domain.
//
// Identity Resolution Jobs are set up using the Amazon Connect admin console. For
// more information, see [Use Identity Resolution to consolidate similar profiles].
//
// [Use Identity Resolution to consolidate similar profiles]: https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html
func (c *Client) GetIdentityResolutionJob(ctx context.Context, params *GetIdentityResolutionJobInput, optFns ...func(*Options)) (*GetIdentityResolutionJobOutput, error) {
	if params == nil {
		params = &GetIdentityResolutionJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIdentityResolutionJob", params, optFns, c.addOperationGetIdentityResolutionJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIdentityResolutionJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIdentityResolutionJobInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The unique identifier of the Identity Resolution Job.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

type GetIdentityResolutionJobOutput struct {

	// Configuration settings for how to perform the auto-merging of profiles.
	AutoMerging *types.AutoMerging

	// The unique name of the domain.
	DomainName *string

	// The S3 location where the Identity Resolution Job writes result files.
	ExportingLocation *types.ExportingLocation

	// The timestamp of when the Identity Resolution Job was completed.
	JobEndTime *time.Time

	// The timestamp of when the Identity Resolution Job will expire.
	JobExpirationTime *time.Time

	// The unique identifier of the Identity Resolution Job.
	JobId *string

	// The timestamp of when the Identity Resolution Job was started or will be
	// started.
	JobStartTime *time.Time

	// Statistics about the Identity Resolution Job.
	JobStats *types.JobStats

	// The timestamp of when the Identity Resolution Job was most recently edited.
	LastUpdatedAt *time.Time

	// The error messages that are generated when the Identity Resolution Job runs.
	Message *string

	// The status of the Identity Resolution Job.
	//
	//   - PENDING : The Identity Resolution Job is scheduled but has not started yet.
	//   If you turn off the Identity Resolution feature in your domain, jobs in the
	//   PENDING state are deleted.
	//
	//   - PREPROCESSING : The Identity Resolution Job is loading your data.
	//
	//   - FIND_MATCHING : The Identity Resolution Job is using the machine learning
	//   model to identify profiles that belong to the same matching group.
	//
	//   - MERGING : The Identity Resolution Job is merging duplicate profiles.
	//
	//   - COMPLETED : The Identity Resolution Job completed successfully.
	//
	//   - PARTIAL_SUCCESS : There's a system error and not all of the data is merged.
	//   The Identity Resolution Job writes a message indicating the source of the
	//   problem.
	//
	//   - FAILED : The Identity Resolution Job did not merge any data. It writes a
	//   message indicating the source of the problem.
	Status types.IdentityResolutionJobStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIdentityResolutionJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetIdentityResolutionJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetIdentityResolutionJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIdentityResolutionJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetIdentityResolutionJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIdentityResolutionJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetIdentityResolutionJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIdentityResolutionJob",
	}
}
