// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The requested analysis can't be found.
type AnalysisNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AnalysisNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AnalysisNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AnalysisNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AnalysisNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *AnalysisNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

//	A request to backfill is already in progress. Once the previous request is
//
// complete, you can create another request.
type BackfillLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BackfillLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BackfillLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BackfillLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BackfillLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *BackfillLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested report expired. Update the date interval and try again.
type BillExpirationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BillExpirationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BillExpirationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BillExpirationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BillExpirationException"
	}
	return *e.ErrorCodeOverride
}
func (e *BillExpirationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

//	The billing view status must be HEALTHY to perform this action. Try again when
//
// the status is HEALTHY .
type BillingViewHealthStatusException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BillingViewHealthStatusException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BillingViewHealthStatusException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BillingViewHealthStatusException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BillingViewHealthStatusException"
	}
	return *e.ErrorCodeOverride
}
func (e *BillingViewHealthStatusException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested data is unavailable.
type DataUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DataUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DataUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DataUnavailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DataUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *DataUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A request to generate a recommendation or analysis is already in progress.
type GenerationExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GenerationExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GenerationExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GenerationExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GenerationExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *GenerationExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pagination token is invalid. Try again without a pagination token.
type InvalidNextTokenException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextTokenException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidNextTokenException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidNextTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You made too many calls in a short period of time. Try again later.
type LimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your request parameters changed between pages. Try again with the old
// parameters or without a pagination token.
type RequestChangedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RequestChangedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RequestChangedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RequestChangedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RequestChangedException"
	}
	return *e.ErrorCodeOverride
}
func (e *RequestChangedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified ARN in the request doesn't exist.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceName *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

//	You've reached the limit on the number of resources you can create, or
//
// exceeded the size of an individual resource.
type ServiceQuotaExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceQuotaExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceQuotaExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceQuotaExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceQuotaExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Can occur if you specify a number of tags for a resource greater than the
// maximum 50 user tags per resource.
type TooManyTagsException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceName *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTagsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cost anomaly monitor does not exist for the account.
type UnknownMonitorException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnknownMonitorException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnknownMonitorException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnknownMonitorException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnknownMonitorException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnknownMonitorException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cost anomaly subscription does not exist for the account.
type UnknownSubscriptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnknownSubscriptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnknownSubscriptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnknownSubscriptionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnknownSubscriptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnknownSubscriptionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cost Explorer was unable to identify the usage unit. Provide
// UsageType/UsageTypeGroup filter selections that contain matching units, for
// example: hours .
type UnresolvableUsageUnitException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnresolvableUsageUnitException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnresolvableUsageUnitException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnresolvableUsageUnitException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnresolvableUsageUnitException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnresolvableUsageUnitException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
