// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the details for a Savings Plan recommendation. These details include
// the hourly data-points that construct the cost, coverage, and utilization
// charts.
func (c *Client) GetSavingsPlanPurchaseRecommendationDetails(ctx context.Context, params *GetSavingsPlanPurchaseRecommendationDetailsInput, optFns ...func(*Options)) (*GetSavingsPlanPurchaseRecommendationDetailsOutput, error) {
	if params == nil {
		params = &GetSavingsPlanPurchaseRecommendationDetailsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSavingsPlanPurchaseRecommendationDetails", params, optFns, c.addOperationGetSavingsPlanPurchaseRecommendationDetailsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSavingsPlanPurchaseRecommendationDetailsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSavingsPlanPurchaseRecommendationDetailsInput struct {

	// The ID that is associated with the Savings Plan recommendation.
	//
	// This member is required.
	RecommendationDetailId *string

	noSmithyDocumentSerde
}

type GetSavingsPlanPurchaseRecommendationDetailsOutput struct {

	// Contains detailed information about a specific Savings Plan recommendation.
	RecommendationDetailData *types.RecommendationDetailData

	// The ID that is associated with the Savings Plan recommendation.
	RecommendationDetailId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSavingsPlanPurchaseRecommendationDetailsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetSavingsPlanPurchaseRecommendationDetails{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetSavingsPlanPurchaseRecommendationDetails{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSavingsPlanPurchaseRecommendationDetails"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetSavingsPlanPurchaseRecommendationDetailsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSavingsPlanPurchaseRecommendationDetails(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSavingsPlanPurchaseRecommendationDetails(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSavingsPlanPurchaseRecommendationDetails",
	}
}
