// Code generated by smithy-go-codegen DO NOT EDIT.

package connectparticipant

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connectparticipant/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates the participant's connection.
//
// For security recommendations, see [Amazon Connect Chat security best practices].
//
// For WebRTC security recommendations, see [Amazon Connect WebRTC security best practices].
//
// ParticipantToken is used for invoking this API instead of ConnectionToken .
//
// The participant token is valid for the lifetime of the participant – until they
// are part of a contact. For WebRTC participants, if they leave or are
// disconnected for 60 seconds, a new participant needs to be created using the [CreateParticipant]
// API.
//
// For WEBSOCKET Type:
//
// The response URL for has a connect expiry timeout of 100s. Clients must
// manually connect to the returned websocket URL and subscribe to the desired
// topic.
//
// For chat, you need to publish the following on the established websocket
// connection:
//
//	{"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}
//
// Upon websocket URL expiry, as specified in the response ConnectionExpiry
// parameter, clients need to call this API again to obtain a new websocket URL and
// perform the same steps as before.
//
// The expiry time for the connection token is different than the
// ChatDurationInMinutes . Expiry time for the connection token is 1 day.
//
// For WEBRTC_CONNECTION Type:
//
// The response includes connection data required for the client application to
// join the call using the Amazon Chime SDK client libraries. The WebRTCConnection
// response contains Meeting and Attendee information needed to establish the media
// connection.
//
// The attendee join token in WebRTCConnection response is valid for the lifetime
// of the participant in the call. If a participant leaves or is disconnected for
// 60 seconds, their participant credentials will no longer be valid, and a new
// participant will need to be created to rejoin the call.
//
// Message streaming support: This API can also be used together with the [StartContactStreaming] API to
// create a participant connection for chat contacts that are not using a
// websocket. For more information about message streaming, [Enable real-time chat message streaming]in the Amazon Connect
// Administrator Guide.
//
// Multi-user web, in-app, video calling support:
//
// For WebRTC calls, this API is used in conjunction with the CreateParticipant
// API to enable multi-party calling. The StartWebRTCContact API creates the
// initial contact and routes it to an agent, while CreateParticipant adds
// additional participants to the ongoing call. For more information about
// multi-party WebRTC calls, see [Enable multi-user web, in-app, and video calling]in the Amazon Connect Administrator Guide.
//
// Feature specifications: For information about feature specifications, such as
// the allowed number of open websocket connections per participant or maximum
// number of WebRTC participants, see [Feature specifications]in the Amazon Connect Administrator Guide.
//
// The Amazon Connect Participant Service APIs do not use [Signature Version 4 authentication].
//
// [Feature specifications]: https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits
// [StartContactStreaming]: https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html
// [CreateParticipant]: https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateParticipant.html
// [Amazon Connect WebRTC security best practices]: https://docs.aws.amazon.com/connect/latest/adminguide/security-best-practices.html#bp-webrtc-security
// [Enable real-time chat message streaming]: https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html
// [Signature Version 4 authentication]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
// [Enable multi-user web, in-app, and video calling]: https://docs.aws.amazon.com/connect/latest/adminguide/enable-multiuser-inapp.html
// [Amazon Connect Chat security best practices]: https://docs.aws.amazon.com/connect/latest/adminguide/security-best-practices.html#bp-security-chat
func (c *Client) CreateParticipantConnection(ctx context.Context, params *CreateParticipantConnectionInput, optFns ...func(*Options)) (*CreateParticipantConnectionOutput, error) {
	if params == nil {
		params = &CreateParticipantConnectionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateParticipantConnection", params, optFns, c.addOperationCreateParticipantConnectionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateParticipantConnectionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateParticipantConnectionInput struct {

	// This is a header parameter.
	//
	// The ParticipantToken as obtained from [StartChatContact] API response.
	//
	// [StartChatContact]: https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html
	//
	// This member is required.
	ParticipantToken *string

	// Amazon Connect Participant is used to mark the participant as connected for
	// customer participant in message streaming, as well as for agent or manager
	// participant in non-streaming chats.
	ConnectParticipant *bool

	// Type of connection information required. If you need CONNECTION_CREDENTIALS
	// along with marking participant as connected, pass CONNECTION_CREDENTIALS in Type
	// .
	Type []types.ConnectionType

	noSmithyDocumentSerde
}

type CreateParticipantConnectionOutput struct {

	// Creates the participant's connection credentials. The authentication token
	// associated with the participant's connection.
	ConnectionCredentials *types.ConnectionCredentials

	// Creates the participant's WebRTC connection data required for the client
	// application (mobile application or website) to connect to the call.
	WebRTCConnection *types.WebRTCConnection

	// Creates the participant's websocket connection.
	Websocket *types.Websocket

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateParticipantConnectionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateParticipantConnection{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateParticipantConnection{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateParticipantConnection"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateParticipantConnectionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateParticipantConnection(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateParticipantConnection(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateParticipantConnection",
	}
}
