// Code generated by smithy-go-codegen DO NOT EDIT.

package connectcases

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connectcases/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches for related items across all cases within a domain. This is a global
// search operation that returns related items from multiple cases, unlike the
// case-specific [SearchRelatedItems]API.
//
// # Use cases
//
// Following are common uses cases for this API:
//
//   - Find cases with similar issues across the domain. For example, search for
//     all cases containing comments about "product defect" to identify patterns and
//     existing solutions.
//
//   - Locate all cases associated with specific contacts or orders. For example,
//     find all cases linked to a contactArn to understand the complete customer
//     journey.
//
//   - Monitor SLA compliance across cases. For example, search for all cases with
//     "Active" SLA status to prioritize remediation efforts.
//
// Important things to know
//
//   - This API returns case identifiers, not complete case objects. To retrieve
//     full case details, you must make additional calls to the [GetCase]API for each
//     returned case ID.
//
//   - This API searches across related items content, not case fields. Use the [SearchCases]
//     API to search within case field values.
//
// Endpoints: See [Amazon Connect endpoints and quotas].
//
// [GetCase]: https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_GetCase.html
// [SearchCases]: https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_SearchCases.html
// [Amazon Connect endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/connect_region.html
// [SearchRelatedItems]: https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_SearchRelatedItems.html
func (c *Client) SearchAllRelatedItems(ctx context.Context, params *SearchAllRelatedItemsInput, optFns ...func(*Options)) (*SearchAllRelatedItemsOutput, error) {
	if params == nil {
		params = &SearchAllRelatedItemsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchAllRelatedItems", params, optFns, c.addOperationSearchAllRelatedItemsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchAllRelatedItemsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchAllRelatedItemsInput struct {

	// The unique identifier of the Cases domain.
	//
	// This member is required.
	DomainId *string

	// The list of types of related items and their parameters to use for filtering.
	// The filters work as an OR condition: caller gets back related items that match
	// any of the specified filter types.
	Filters []types.RelatedItemTypeFilter

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// A structured set of sort terms to specify the order in which related items
	// should be returned. Supports sorting by association time or case ID. The sorts
	// work in the order specified: first sort term takes precedence over subsequent
	// terms.
	Sorts []types.SearchAllRelatedItemsSort

	noSmithyDocumentSerde
}

type SearchAllRelatedItemsOutput struct {

	// A list of items related to a case.
	//
	// This member is required.
	RelatedItems []*types.SearchAllRelatedItemsResponseItem

	// The token for the next set of results. This is null if there are no more
	// results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchAllRelatedItemsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchAllRelatedItems{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchAllRelatedItems{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchAllRelatedItems"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchAllRelatedItemsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchAllRelatedItems(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchAllRelatedItemsPaginatorOptions is the paginator options for
// SearchAllRelatedItems
type SearchAllRelatedItemsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchAllRelatedItemsPaginator is a paginator for SearchAllRelatedItems
type SearchAllRelatedItemsPaginator struct {
	options   SearchAllRelatedItemsPaginatorOptions
	client    SearchAllRelatedItemsAPIClient
	params    *SearchAllRelatedItemsInput
	nextToken *string
	firstPage bool
}

// NewSearchAllRelatedItemsPaginator returns a new SearchAllRelatedItemsPaginator
func NewSearchAllRelatedItemsPaginator(client SearchAllRelatedItemsAPIClient, params *SearchAllRelatedItemsInput, optFns ...func(*SearchAllRelatedItemsPaginatorOptions)) *SearchAllRelatedItemsPaginator {
	if params == nil {
		params = &SearchAllRelatedItemsInput{}
	}

	options := SearchAllRelatedItemsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchAllRelatedItemsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchAllRelatedItemsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchAllRelatedItems page.
func (p *SearchAllRelatedItemsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchAllRelatedItemsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchAllRelatedItems(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchAllRelatedItemsAPIClient is a client that implements the
// SearchAllRelatedItems operation.
type SearchAllRelatedItemsAPIClient interface {
	SearchAllRelatedItems(context.Context, *SearchAllRelatedItemsInput, ...func(*Options)) (*SearchAllRelatedItemsOutput, error)
}

var _ SearchAllRelatedItemsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchAllRelatedItems(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchAllRelatedItems",
	}
}
