// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the primary values for a record. This operation affects all existing
// values that are currently associated to the record and its primary values. Users
// that have restrictions on attributes and/or primary values are not authorized to
// use this endpoint. The combination of new primary values must be unique within
// the table.
func (c *Client) UpdateDataTablePrimaryValues(ctx context.Context, params *UpdateDataTablePrimaryValuesInput, optFns ...func(*Options)) (*UpdateDataTablePrimaryValuesOutput, error) {
	if params == nil {
		params = &UpdateDataTablePrimaryValuesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDataTablePrimaryValues", params, optFns, c.addOperationUpdateDataTablePrimaryValuesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDataTablePrimaryValuesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDataTablePrimaryValuesInput struct {

	// The unique identifier for the data table. Must also accept the table ARN with
	// or without a version alias. If the version is provided as part of the identifier
	// or ARN, the version must be one of the two available system managed aliases,
	// $SAVED or $LATEST.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// The lock version information required for optimistic locking to prevent
	// concurrent modifications.
	//
	// This member is required.
	LockVersion *types.DataTableLockVersion

	// The new primary values for the record. Required and must include values for all
	// primary attributes. The combination must be unique within the table.
	//
	// This member is required.
	NewPrimaryValues []types.PrimaryValue

	// The current primary values for the record. Required and must include values for
	// all primary attributes. Fails if the table has primary attributes and some
	// primary values are omitted.
	//
	// This member is required.
	PrimaryValues []types.PrimaryValue

	noSmithyDocumentSerde
}

type UpdateDataTablePrimaryValuesOutput struct {

	// The updated lock version information for the data table and affected components
	// after the primary values change.
	//
	// This member is required.
	LockVersion *types.DataTableLockVersion

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDataTablePrimaryValuesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDataTablePrimaryValues{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDataTablePrimaryValues{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDataTablePrimaryValues"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDataTablePrimaryValuesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDataTablePrimaryValues(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDataTablePrimaryValues(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDataTablePrimaryValues",
	}
}
