// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates all properties for an attribute using all properties from
// CreateDataTableAttribute. There are no other granular update endpoints. It does
// not act as a patch operation - all properties must be provided. System managed
// attributes are not mutable by customers. Changing an attribute's validation does
// not invalidate existing values since validation only runs when values are
// created or updated.
func (c *Client) UpdateDataTableAttribute(ctx context.Context, params *UpdateDataTableAttributeInput, optFns ...func(*Options)) (*UpdateDataTableAttributeOutput, error) {
	if params == nil {
		params = &UpdateDataTableAttributeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDataTableAttribute", params, optFns, c.addOperationUpdateDataTableAttributeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDataTableAttributeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDataTableAttributeInput struct {

	// The current name of the attribute to update. Used as an identifier since
	// attribute names can be changed.
	//
	// This member is required.
	AttributeName *string

	// The unique identifier for the data table. Must also accept the table ARN with
	// or without a version alias.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// The new name for the attribute. Must conform to Connect human readable string
	// specification and be unique within the data table.
	//
	// This member is required.
	Name *string

	// The updated value type for the attribute. When changing value types, existing
	// values are not deleted but may return default values if incompatible.
	//
	// This member is required.
	ValueType types.DataTableAttributeValueType

	// The updated description for the attribute.
	Description *string

	// Whether the attribute should be treated as a primary key. Converting to primary
	// attribute requires existing values to maintain uniqueness.
	Primary bool

	// The updated validation rules for the attribute. Changes do not affect existing
	// values until they are modified.
	Validation *types.Validation

	noSmithyDocumentSerde
}

type UpdateDataTableAttributeOutput struct {

	// The new lock version for the attribute after the update.
	//
	// This member is required.
	LockVersion *types.DataTableLockVersion

	// The trimmed name and identifier for the updated attribute.
	//
	// This member is required.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDataTableAttributeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDataTableAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDataTableAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDataTableAttribute"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDataTableAttributeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDataTableAttribute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDataTableAttribute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDataTableAttribute",
	}
}
