// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API is in preview release for Amazon Connect and is subject to change. To
// request access to this API, contact Amazon Web Services Support.
//
// Updates the selected authentication profile.
func (c *Client) UpdateAuthenticationProfile(ctx context.Context, params *UpdateAuthenticationProfileInput, optFns ...func(*Options)) (*UpdateAuthenticationProfileOutput, error) {
	if params == nil {
		params = &UpdateAuthenticationProfileInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAuthenticationProfile", params, optFns, c.addOperationUpdateAuthenticationProfileMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAuthenticationProfileOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAuthenticationProfileInput struct {

	// A unique identifier for the authentication profile.
	//
	// This member is required.
	AuthenticationProfileId *string

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// A list of IP address range strings that are allowed to access the instance. For
	// more information on how to configure IP addresses, see[Configure session timeouts] in the Amazon Connect
	// Administrator Guide.
	//
	// [Configure session timeouts]: https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts
	AllowedIps []string

	// A list of IP address range strings that are blocked from accessing the
	// instance. For more information on how to configure IP addresses, For more
	// information on how to configure IP addresses, see [Configure IP-based access control]in the Amazon Connect
	// Administrator Guide.
	//
	// [Configure IP-based access control]: https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac
	BlockedIps []string

	// The description for the authentication profile.
	Description *string

	// The name for the authentication profile.
	Name *string

	// The short lived session duration configuration for users logged in to Amazon
	// Connect, in minutes. This value determines the maximum possible time before an
	// agent is authenticated. For more information, For more information on how to
	// configure IP addresses, see [Configure session timeouts]in the Amazon Connect Administrator Guide.
	//
	// [Configure session timeouts]: https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts
	//
	// Deprecated: PeriodicSessionDuration is deprecated. Use
	// SessionInactivityDuration instead.
	PeriodicSessionDuration *int32

	// The period, in minutes, before an agent is automatically signed out of the
	// contact center when they go inactive.
	SessionInactivityDuration *int32

	// Determines if automatic logout on user inactivity is enabled.
	SessionInactivityHandlingEnabled *bool

	noSmithyDocumentSerde
}

type UpdateAuthenticationProfileOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAuthenticationProfileMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAuthenticationProfile{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAuthenticationProfile{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAuthenticationProfile"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAuthenticationProfileValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAuthenticationProfile(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAuthenticationProfile(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAuthenticationProfile",
	}
}
