// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches the flows in an Amazon Connect instance, with optional filtering.
func (c *Client) SearchContactFlows(ctx context.Context, params *SearchContactFlowsInput, optFns ...func(*Options)) (*SearchContactFlowsOutput, error) {
	if params == nil {
		params = &SearchContactFlowsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchContactFlows", params, optFns, c.addOperationSearchContactFlowsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchContactFlowsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchContactFlowsInput struct {

	// The identifier of the Amazon Connect instance. You can find the instance ID in
	// the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// The search criteria to be used to return flows.
	//
	// The name and description fields support "contains" queries with a minimum of 2
	// characters and a maximum of 25 characters. Any queries with character lengths
	// outside of this range will result in invalid results.
	SearchCriteria *types.ContactFlowSearchCriteria

	// Filters to be applied to search results.
	SearchFilter *types.ContactFlowSearchFilter

	noSmithyDocumentSerde
}

type SearchContactFlowsOutput struct {

	// The total number of flows which matched your search query.
	ApproximateTotalCount *int64

	// Information about the flows.
	ContactFlows []types.ContactFlow

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchContactFlowsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchContactFlows{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchContactFlows{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchContactFlows"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchContactFlowsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchContactFlows(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchContactFlowsPaginatorOptions is the paginator options for
// SearchContactFlows
type SearchContactFlowsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchContactFlowsPaginator is a paginator for SearchContactFlows
type SearchContactFlowsPaginator struct {
	options   SearchContactFlowsPaginatorOptions
	client    SearchContactFlowsAPIClient
	params    *SearchContactFlowsInput
	nextToken *string
	firstPage bool
}

// NewSearchContactFlowsPaginator returns a new SearchContactFlowsPaginator
func NewSearchContactFlowsPaginator(client SearchContactFlowsAPIClient, params *SearchContactFlowsInput, optFns ...func(*SearchContactFlowsPaginatorOptions)) *SearchContactFlowsPaginator {
	if params == nil {
		params = &SearchContactFlowsInput{}
	}

	options := SearchContactFlowsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchContactFlowsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchContactFlowsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchContactFlows page.
func (p *SearchContactFlowsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchContactFlowsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchContactFlows(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchContactFlowsAPIClient is a client that implements the SearchContactFlows
// operation.
type SearchContactFlowsAPIClient interface {
	SearchContactFlows(context.Context, *SearchContactFlowsInput, ...func(*Options)) (*SearchContactFlowsOutput, error)
}

var _ SearchContactFlowsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchContactFlows(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchContactFlows",
	}
}
