// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns all attributes for a specified data table. A maximum of 100 attributes
// per data table is allowed. Customers can request an increase by using AWS
// Service Quotas. The response can be filtered by specific attribute IDs for
// CloudFormation integration.
func (c *Client) ListDataTableAttributes(ctx context.Context, params *ListDataTableAttributesInput, optFns ...func(*Options)) (*ListDataTableAttributesOutput, error) {
	if params == nil {
		params = &ListDataTableAttributesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataTableAttributes", params, optFns, c.addOperationListDataTableAttributesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataTableAttributesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataTableAttributesInput struct {

	// The unique identifier for the data table whose attributes should be listed.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// Optional list of specific attribute IDs to retrieve. Used for CloudFormation to
	// effectively describe attributes by ID. If NextToken is provided, this parameter
	// is ignored.
	AttributeIds []string

	// The maximum number of data table attributes to return in one page of results.
	MaxResults *int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDataTableAttributesOutput struct {

	// A list of data table attributes with their complete configuration and metadata.
	//
	// This member is required.
	Attributes []types.DataTableAttribute

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataTableAttributesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataTableAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataTableAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataTableAttributes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataTableAttributesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataTableAttributes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDataTableAttributesPaginatorOptions is the paginator options for
// ListDataTableAttributes
type ListDataTableAttributesPaginatorOptions struct {
	// The maximum number of data table attributes to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataTableAttributesPaginator is a paginator for ListDataTableAttributes
type ListDataTableAttributesPaginator struct {
	options   ListDataTableAttributesPaginatorOptions
	client    ListDataTableAttributesAPIClient
	params    *ListDataTableAttributesInput
	nextToken *string
	firstPage bool
}

// NewListDataTableAttributesPaginator returns a new
// ListDataTableAttributesPaginator
func NewListDataTableAttributesPaginator(client ListDataTableAttributesAPIClient, params *ListDataTableAttributesInput, optFns ...func(*ListDataTableAttributesPaginatorOptions)) *ListDataTableAttributesPaginator {
	if params == nil {
		params = &ListDataTableAttributesInput{}
	}

	options := ListDataTableAttributesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataTableAttributesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataTableAttributesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataTableAttributes page.
func (p *ListDataTableAttributesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataTableAttributesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataTableAttributes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataTableAttributesAPIClient is a client that implements the
// ListDataTableAttributes operation.
type ListDataTableAttributesAPIClient interface {
	ListDataTableAttributes(context.Context, *ListDataTableAttributesInput, ...func(*Options)) (*ListDataTableAttributesOutput, error)
}

var _ ListDataTableAttributesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataTableAttributes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataTableAttributes",
	}
}
