// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new data table with the specified properties. Supports the creation
// of all table properties except for attributes and values. A table with no
// attributes and values is a valid state for a table. The number of tables per
// instance is limited to 100 per instance. Customers can request an increase by
// using AWS Service Quotas.
func (c *Client) CreateDataTable(ctx context.Context, params *CreateDataTableInput, optFns ...func(*Options)) (*CreateDataTableOutput, error) {
	if params == nil {
		params = &CreateDataTableInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataTable", params, optFns, c.addOperationCreateDataTableMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataTableOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataTableInput struct {

	// The unique identifier for the Amazon Connect instance where the data table will
	// be created.
	//
	// This member is required.
	InstanceId *string

	// The name for the data table. Must conform to Connect human readable string
	// specification and have 1-127 characters. Whitespace must be trimmed first. Must
	// not start with the reserved case insensitive values 'connect:' and 'aws:'. Must
	// be unique for the instance using case-insensitive comparison.
	//
	// This member is required.
	Name *string

	// The status of the data table. One of PUBLISHED or SAVED. Required parameter
	// that determines the initial state of the table.
	//
	// This member is required.
	Status types.DataTableStatus

	// The IANA timezone identifier to use when resolving time based dynamic values.
	// Required even if no time slices are specified.
	//
	// This member is required.
	TimeZone *string

	// The data level that concurrent value edits are locked on. One of DATA_TABLE,
	// PRIMARY_VALUE, ATTRIBUTE, VALUE, and NONE. NONE is the default if unspecified.
	// This determines how concurrent edits are handled when multiple users attempt to
	// modify values simultaneously.
	//
	// This member is required.
	ValueLockLevel types.DataTableLockLevel

	// An optional description for the data table. Must conform to Connect human
	// readable string specification and have 0-250 characters. Whitespace must be
	// trimmed first.
	Description *string

	// Key value pairs for attribute based access control (TBAC or ABAC). Optional
	// tags to apply to the data table for organization and access control purposes.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateDataTableOutput struct {

	// The Amazon Resource Name (ARN) for the created data table. Does not include the
	// version alias.
	//
	// This member is required.
	Arn *string

	// The unique identifier for the created data table. Does not include the version
	// alias.
	//
	// This member is required.
	Id *string

	// The lock version information for the created data table, used for optimistic
	// locking and table versioning.
	//
	// This member is required.
	LockVersion *types.DataTableLockVersion

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataTableMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDataTable{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDataTable{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataTable"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDataTableValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataTable(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataTable(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataTable",
	}
}
