// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves multiple values from a data table without evaluating expressions.
// Returns the raw stored values along with metadata such as lock versions and
// modification timestamps. "Describe" is a deprecated term but is allowed to
// maintain consistency with existing operations.
func (c *Client) BatchDescribeDataTableValue(ctx context.Context, params *BatchDescribeDataTableValueInput, optFns ...func(*Options)) (*BatchDescribeDataTableValueOutput, error) {
	if params == nil {
		params = &BatchDescribeDataTableValueInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDescribeDataTableValue", params, optFns, c.addOperationBatchDescribeDataTableValueMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDescribeDataTableValueOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDescribeDataTableValueInput struct {

	// The unique identifier for the data table. Must also accept the table ARN with
	// or without a version alias.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// A list of value identifiers to retrieve, each specifying primary values and
	// attribute names.
	//
	// This member is required.
	Values []types.DataTableValueIdentifier

	noSmithyDocumentSerde
}

type BatchDescribeDataTableValueOutput struct {

	// A list of values that failed to be retrieved with error messages explaining the
	// failure reason.
	//
	// This member is required.
	Failed []types.BatchDescribeDataTableValueFailureResult

	// A list of successfully retrieved values with their data, metadata, and lock
	// version information.
	//
	// This member is required.
	Successful []types.BatchDescribeDataTableValueSuccessResult

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDescribeDataTableValueMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchDescribeDataTableValue{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchDescribeDataTableValue{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDescribeDataTableValue"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchDescribeDataTableValueValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDescribeDataTableValue(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDescribeDataTableValue(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDescribeDataTableValue",
	}
}
