// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing automation rule.
func (c *Client) UpdateAutomationRule(ctx context.Context, params *UpdateAutomationRuleInput, optFns ...func(*Options)) (*UpdateAutomationRuleOutput, error) {
	if params == nil {
		params = &UpdateAutomationRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAutomationRule", params, optFns, c.addOperationUpdateAutomationRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAutomationRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAutomationRuleInput struct {

	//  The ARN of the rule to update.
	//
	// This member is required.
	RuleArn *string

	//  The revision number of the rule to update.
	//
	// This member is required.
	RuleRevision *int64

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Must be 1-64 characters long and contain only alphanumeric
	// characters, underscores, and hyphens.
	ClientToken *string

	//  A set of conditions that specify which recommended action qualify for
	// implementation. When a rule is active and a recommended action matches these
	// criteria, Compute Optimizer implements the action at the scheduled run time. You
	// can specify up to 20 conditions per filter criteria and 20 values per condition.
	Criteria *types.Criteria

	// The updated description of the automation rule. Can be up to 1024 characters
	// long and contain alphanumeric characters, underscores, hyphens, spaces, and
	// certain special characters.
	Description *string

	// The updated name of the automation rule. Must be 1-128 characters long and
	// contain only alphanumeric characters, underscores, and hyphens.
	Name *string

	// Updated configuration settings for organization-wide rules, including rule
	// application order and target account IDs.
	OrganizationConfiguration *types.OrganizationConfiguration

	// The updated priority level of the automation rule, used to determine execution
	// order when multiple rules apply to the same resource.
	Priority *string

	// Updated list of recommended action types that this rule can execute, such as
	// SnapshotAndDeleteUnattachedEbsVolume or UpgradeEbsVolumeType.
	RecommendedActionTypes []types.RecommendedActionType

	// The updated type of automation rule. Can be either OrganizationRule for
	// organization-wide rules or AccountRule for account-specific rules.
	RuleType types.RuleType

	// The updated schedule configuration for when the automation rule should execute,
	// including cron expression, timezone, and execution window.
	Schedule *types.Schedule

	// The updated status of the automation rule. Can be Active or Inactive.
	Status types.RuleStatus

	noSmithyDocumentSerde
}

type UpdateAutomationRuleOutput struct {

	// The timestamp when the automation rule was originally created.
	CreatedTimestamp *time.Time

	//  A set of conditions that specify which recommended action qualify for
	// implementation. When a rule is active and a recommended action matches these
	// criteria, Compute Optimizer implements the action at the scheduled run time. You
	// can specify up to 20 conditions per filter criteria and 20 values per condition.
	Criteria *types.Criteria

	// The updated description of the automation rule.
	Description *string

	// The timestamp when the automation rule was last updated.
	LastUpdatedTimestamp *time.Time

	// The updated name of the automation rule.
	Name *string

	// The updated organization configuration settings.
	OrganizationConfiguration *types.OrganizationConfiguration

	// The updated priority level of the automation rule.
	Priority *string

	// The updated list of recommended action types.
	RecommendedActionTypes []types.RecommendedActionType

	//  The ARN of the updated rule.
	RuleArn *string

	//  The new revision number of the updated rule.
	RuleRevision *int64

	// The updated type of automation rule.
	RuleType types.RuleType

	// The updated schedule configuration.
	Schedule *types.Schedule

	// The updated status of the automation rule.
	Status types.RuleStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAutomationRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateAutomationRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateAutomationRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAutomationRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateAutomationRuleMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAutomationRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAutomationRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateAutomationRule struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateAutomationRule) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateAutomationRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateAutomationRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateAutomationRuleInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateAutomationRuleMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateAutomationRule{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateAutomationRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAutomationRule",
	}
}
