// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists automation events based on specified filters. You can retrieve events
// that were created within the past year.
func (c *Client) ListAutomationEvents(ctx context.Context, params *ListAutomationEventsInput, optFns ...func(*Options)) (*ListAutomationEventsOutput, error) {
	if params == nil {
		params = &ListAutomationEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomationEvents", params, optFns, c.addOperationListAutomationEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomationEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomationEventsInput struct {

	//  The end of the time range to query for events.
	EndTimeExclusive *time.Time

	//  The filters to apply to the list of automation events.
	Filters []types.AutomationEventFilter

	//  The maximum number of results to return in a single call.
	MaxResults *int32

	//  The token for the next page of results.
	NextToken *string

	//  The start of the time range to query for events.
	StartTimeInclusive *time.Time

	noSmithyDocumentSerde
}

type ListAutomationEventsOutput struct {

	//  The list of automation events that match the specified criteria.
	AutomationEvents []types.AutomationEvent

	//  The token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomationEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAutomationEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAutomationEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomationEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomationEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomationEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAutomationEventsPaginatorOptions is the paginator options for
// ListAutomationEvents
type ListAutomationEventsPaginatorOptions struct {
	//  The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomationEventsPaginator is a paginator for ListAutomationEvents
type ListAutomationEventsPaginator struct {
	options   ListAutomationEventsPaginatorOptions
	client    ListAutomationEventsAPIClient
	params    *ListAutomationEventsInput
	nextToken *string
	firstPage bool
}

// NewListAutomationEventsPaginator returns a new ListAutomationEventsPaginator
func NewListAutomationEventsPaginator(client ListAutomationEventsAPIClient, params *ListAutomationEventsInput, optFns ...func(*ListAutomationEventsPaginatorOptions)) *ListAutomationEventsPaginator {
	if params == nil {
		params = &ListAutomationEventsInput{}
	}

	options := ListAutomationEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomationEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomationEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomationEvents page.
func (p *ListAutomationEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomationEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomationEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomationEventsAPIClient is a client that implements the
// ListAutomationEvents operation.
type ListAutomationEventsAPIClient interface {
	ListAutomationEvents(context.Context, *ListAutomationEventsInput, ...func(*Options)) (*ListAutomationEventsOutput, error)
}

var _ ListAutomationEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomationEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomationEvents",
	}
}
