// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides a summary of automation events based on specified filters. Only events
// created within the past year will be included in the summary.
func (c *Client) ListAutomationEventSummaries(ctx context.Context, params *ListAutomationEventSummariesInput, optFns ...func(*Options)) (*ListAutomationEventSummariesOutput, error) {
	if params == nil {
		params = &ListAutomationEventSummariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomationEventSummaries", params, optFns, c.addOperationListAutomationEventSummariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomationEventSummariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomationEventSummariesInput struct {

	// The end date for filtering automation event summaries, exclusive. Events
	// created before this date will be included.
	EndDateExclusive *string

	//  The filters to apply to the list of automation event summaries.
	Filters []types.AutomationEventFilter

	// The maximum number of automation event summaries to return in a single
	// response. Valid range is 1-1000.
	MaxResults *int32

	// A token used for pagination to retrieve the next set of results when the
	// response is truncated.
	NextToken *string

	// The start date for filtering automation event summaries, inclusive. Events
	// created on or after this date will be included.
	StartDateInclusive *string

	noSmithyDocumentSerde
}

type ListAutomationEventSummariesOutput struct {

	//  The list of automation event summaries that match the specified criteria.
	AutomationEventSummaries []types.AutomationEventSummary

	// A token used for pagination. If present, indicates there are more results
	// available and can be used in subsequent requests.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomationEventSummariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAutomationEventSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAutomationEventSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomationEventSummaries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomationEventSummariesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomationEventSummaries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAutomationEventSummariesPaginatorOptions is the paginator options for
// ListAutomationEventSummaries
type ListAutomationEventSummariesPaginatorOptions struct {
	// The maximum number of automation event summaries to return in a single
	// response. Valid range is 1-1000.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomationEventSummariesPaginator is a paginator for
// ListAutomationEventSummaries
type ListAutomationEventSummariesPaginator struct {
	options   ListAutomationEventSummariesPaginatorOptions
	client    ListAutomationEventSummariesAPIClient
	params    *ListAutomationEventSummariesInput
	nextToken *string
	firstPage bool
}

// NewListAutomationEventSummariesPaginator returns a new
// ListAutomationEventSummariesPaginator
func NewListAutomationEventSummariesPaginator(client ListAutomationEventSummariesAPIClient, params *ListAutomationEventSummariesInput, optFns ...func(*ListAutomationEventSummariesPaginatorOptions)) *ListAutomationEventSummariesPaginator {
	if params == nil {
		params = &ListAutomationEventSummariesInput{}
	}

	options := ListAutomationEventSummariesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomationEventSummariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomationEventSummariesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomationEventSummaries page.
func (p *ListAutomationEventSummariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomationEventSummariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomationEventSummaries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomationEventSummariesAPIClient is a client that implements the
// ListAutomationEventSummaries operation.
type ListAutomationEventSummariesAPIClient interface {
	ListAutomationEventSummaries(context.Context, *ListAutomationEventSummariesInput, ...func(*Options)) (*ListAutomationEventSummariesOutput, error)
}

var _ ListAutomationEventSummariesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomationEventSummaries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomationEventSummaries",
	}
}
