// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the steps for a specific automation event. You can only list steps for
// events created within the past year.
func (c *Client) ListAutomationEventSteps(ctx context.Context, params *ListAutomationEventStepsInput, optFns ...func(*Options)) (*ListAutomationEventStepsOutput, error) {
	if params == nil {
		params = &ListAutomationEventStepsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomationEventSteps", params, optFns, c.addOperationListAutomationEventStepsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomationEventStepsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomationEventStepsInput struct {

	//  The ID of the automation event.
	//
	// This member is required.
	EventId *string

	// The maximum number of automation event steps to return in a single response.
	// Valid range is 1-1000.
	MaxResults *int32

	// A token used for pagination to retrieve the next set of results when the
	// response is truncated.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAutomationEventStepsOutput struct {

	//  The list of steps for the specified automation event.
	AutomationEventSteps []types.AutomationEventStep

	// A token used for pagination. If present, indicates there are more results
	// available and can be used in subsequent requests.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomationEventStepsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAutomationEventSteps{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAutomationEventSteps{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomationEventSteps"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAutomationEventStepsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomationEventSteps(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAutomationEventStepsPaginatorOptions is the paginator options for
// ListAutomationEventSteps
type ListAutomationEventStepsPaginatorOptions struct {
	// The maximum number of automation event steps to return in a single response.
	// Valid range is 1-1000.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomationEventStepsPaginator is a paginator for ListAutomationEventSteps
type ListAutomationEventStepsPaginator struct {
	options   ListAutomationEventStepsPaginatorOptions
	client    ListAutomationEventStepsAPIClient
	params    *ListAutomationEventStepsInput
	nextToken *string
	firstPage bool
}

// NewListAutomationEventStepsPaginator returns a new
// ListAutomationEventStepsPaginator
func NewListAutomationEventStepsPaginator(client ListAutomationEventStepsAPIClient, params *ListAutomationEventStepsInput, optFns ...func(*ListAutomationEventStepsPaginatorOptions)) *ListAutomationEventStepsPaginator {
	if params == nil {
		params = &ListAutomationEventStepsInput{}
	}

	options := ListAutomationEventStepsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomationEventStepsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomationEventStepsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomationEventSteps page.
func (p *ListAutomationEventStepsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomationEventStepsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomationEventSteps(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomationEventStepsAPIClient is a client that implements the
// ListAutomationEventSteps operation.
type ListAutomationEventStepsAPIClient interface {
	ListAutomationEventSteps(context.Context, *ListAutomationEventStepsInput, ...func(*Options)) (*ListAutomationEventStepsOutput, error)
}

var _ ListAutomationEventStepsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomationEventSteps(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomationEventSteps",
	}
}
