// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Configures threat protection for a user pool or app client. Sets configuration
// for the following.
//
//   - Responses to risks with adaptive authentication
//
//   - Responses to vulnerable passwords with compromised-credentials detection
//
//   - Notifications to users who have had risky activity detected
//
//   - IP-address denylist and allowlist
//
// To set the risk configuration for the user pool to defaults, send this request
// with only the UserPoolId parameter. To reset the threat protection settings of
// an app client to be inherited from the user pool, send UserPoolId and ClientId
// parameters only. To change threat protection to audit-only or off, update the
// value of UserPoolAddOns in an UpdateUserPool request. To activate this setting,
// your user pool must be on the [Plus tier].
//
// [Plus tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-plus.html
func (c *Client) SetRiskConfiguration(ctx context.Context, params *SetRiskConfigurationInput, optFns ...func(*Options)) (*SetRiskConfigurationOutput, error) {
	if params == nil {
		params = &SetRiskConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SetRiskConfiguration", params, optFns, c.addOperationSetRiskConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SetRiskConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SetRiskConfigurationInput struct {

	// The ID of the user pool where you want to set a risk configuration. If you
	// include UserPoolId in your request, don't include ClientId . When the client ID
	// is null, the same risk configuration is applied to all the clients in the
	// userPool. When you include both ClientId and UserPoolId , Amazon Cognito maps
	// the configuration to the app client only.
	//
	// This member is required.
	UserPoolId *string

	// The settings for automated responses and notification templates for adaptive
	// authentication with threat protection.
	AccountTakeoverRiskConfiguration *types.AccountTakeoverRiskConfigurationType

	// The ID of the app client where you want to set a risk configuration. If ClientId
	// is null, then the risk configuration is mapped to UserPoolId . When the client
	// ID is null, the same risk configuration is applied to all the clients in the
	// userPool.
	//
	// When you include a ClientId parameter, Amazon Cognito maps the configuration to
	// the app client. When you include both ClientId and UserPoolId , Amazon Cognito
	// maps the configuration to the app client only.
	ClientId *string

	// The configuration of automated reactions to detected compromised credentials.
	// Includes settings for blocking future sign-in requests and for the types of
	// password-submission events you want to monitor.
	CompromisedCredentialsRiskConfiguration *types.CompromisedCredentialsRiskConfigurationType

	// A set of IP-address overrides to threat protection. You can set up IP-address
	// always-block and always-allow lists.
	RiskExceptionConfiguration *types.RiskExceptionConfigurationType

	noSmithyDocumentSerde
}

type SetRiskConfigurationOutput struct {

	// The API response that contains the risk configuration that you set and the
	// timestamp of the most recent change.
	//
	// This member is required.
	RiskConfiguration *types.RiskConfigurationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSetRiskConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpSetRiskConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpSetRiskConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SetRiskConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSetRiskConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSetRiskConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSetRiskConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SetRiskConfiguration",
	}
}
